# i18n.py
# Sistema de traduções para FastChecker II
# Suporta Português (PT) e English (EN)

import json
import os

# Dicionário de traduções
TRANSLATIONS = {
    'pt': {
        # App Shell
        'app_shell.error_missing_library': 'Biblioteca Faltando',
        'app_shell.error_missing_library_msg': 'A biblioteca \'Pillow\' é necessária. Instale com: pip install Pillow',
        'app_shell.error_hardware_not_found': 'Erro de Hardware',
        'app_shell.error_hardware_not_found_msg': 'Hardware \'Silicon Labs CP210x\' não encontrado. Verifique a conexão e os drivers.',
        'app_shell.warning_hardware_reset': 'Aviso de Hardware',
        'app_shell.warning_hardware_reset_msg': 'Comando de reset inicial falhou. A conexão pode ser instável.',
        'app_shell.warning_test_in_progress': 'Teste em Andamento',
        'app_shell.warning_test_in_progress_msg': 'Aguarde o teste terminar.',
        'app_shell.error_module_load': 'Erro',
        'app_shell.error_module_load_msg': 'Erro ao carregar módulo {module}:\n{error}',
        'app_shell.error_module_debug': 'Erro de Módulo (Depuração)',
        'app_shell.error_module_debug_msg': 'Ocorreu um erro ao tentar carregar o módulo \'{module}\'.\n\nTraceback completo:\n\n{traceback}',
        
        # Rename Popup
        'rename.title': 'Renomear Tag',
        'rename.epc': 'EPC:',
        'rename.tag_name': 'Nome da Tag:',
        'rename.save': 'Salvar',
        'rename.cancel': 'Cancelar',
        'rename.error_empty_title': 'Erro de Entrada',
        'rename.error_empty_msg': 'O nome da tag não pode estar vazio.',
        'rename.error_max_length_title': 'Erro de Entrada',
        'rename.error_max_length_msg': 'O apelido deve ter no máximo 4 caracteres.',
        'rename.error_database_title': 'Erro de Banco de Dados',
        'rename.error_database_msg': 'Não foi possível atualizar o nome da tag.',
        
        # License Module
        'license.system_information': 'Informações do Sistema',
        'license.software': 'Software:',
        'license.hardware': 'Hardware:',
        'license.firmware': 'Firmware:',
        'license.status_default': 'Sistema de licenças',
        'license.status_connecting': 'Conectando...',
        'license.status_browser_mode': 'Modo Browser - funcionalidade limitada',
        'license.reload_button': 'Recarregar Informações do Sistema',
        'license.license_information': 'Informações da Licença',
        'license.auto_license': 'Auto License',
        'license.import_license': 'Importar Licença',
        'license.eula_agreement': 'Acordo da Licença',
        'license.licenses_on_device': 'Licenças no Dispositivo',
        'license.active': 'Ativa',
        'license.inactive': 'Inativa',
        'license.select': 'Selecionar',
        'license.device_licenced': 'Dispositivo Licenciado',
        'license.device_not_licenced': 'Dispositivo Não Licenciado - Modo Browser',
        'license.device_connected': 'Dispositivo Conectado - Modo Browser',
        
        # RSSI x Power Module
        'rssi_power.browser_mode': 'modo browser',
        'rssi_power.test_config': 'Configuração do Teste',
        'rssi_power.name': 'Nome:',
        'rssi_power.frequency_mhz': 'Frequência (MHz):',
        'rssi_power.samples_per_point': 'Amostras por Ponto:',
        'rssi_power.power_step_dbm': 'Passo de Potência (dBm):',
        'rssi_power.tag_selection': 'Seleção de Tag',
        'rssi_power.register_tag': '🔍 Registro de Tag',
        'rssi_power.no_tag_selected': 'Nenhuma tag selecionada',
        'rssi_power.tag_selected': 'Selecionada:',
        'rssi_power.controls': 'Controles',
        'rssi_power.test': 'Testar',
        'rssi_power.stop': 'Parar',
        'rssi_power.clear_plot': 'Limpar Gráfico',
        'rssi_power.save_selected': 'Salvar Selecionados',
        'rssi_power.import_tests': 'Importar Testes',
        'rssi_power.generate_report': 'Relatório Selecionados (PDF)',
        'rssi_power.graph_title': 'RSSI vs Power',
        'rssi_power.test_history': 'Histórico de Testes',
        'rssi_power.stats_loading': 'Estatísticas: Carregando...',
        'rssi_power.plot': 'Plot',
        'rssi_power.name_col': 'Nome',
        'rssi_power.tag_epc': 'EPC da Tag',
        'rssi_power.frequency_col': 'Freq (MHz)',
        'rssi_power.power_range': 'Potência (dBm)',
        'rssi_power.rssi_range': 'RSSI (dBm)',
        'rssi_power.slope': 'Slope (dBm/dBm)',
        'rssi_power.date_time': 'Data/Hora',
        'rssi_power.select_all': 'Selecionar Todos',
        'rssi_power.stats_format': 'Estatísticas: {count} testes | {tags} tags únicas{slope}',
        'rssi_power.stats_format_single': 'Estatísticas: {count} teste | {tags} tag única{slope}',
        'rssi_power.slope_stats': ' | Slope: {avg:.3f} (min: {min:.3f}, max: {max:.3f})',
        'rssi_power.deselect_all': 'Deselecionar Todos',
        'rssi_power.delete_selected': 'Excluir Selecionados...',
        'rssi_power.zoom': 'Zoom:',
        'rssi_power.live': ' (Ao Vivo)',
        'rssi_power.graph_power_label': 'Potência (dBm)',
        'rssi_power.graph_rssi_label': 'RSSI (dBm)',
        'rssi_power.graph_test_title': 'Teste',
        'rssi_power.graph_rssi_vs_power_title': 'RSSI vs Power',
        'rssi_power.graph_no_data': 'Sem dados disponíveis',
        'rssi_power.graph_trend_label': 'Tendência',
        'rssi_power.graph_trend_slope': 'Tendência (slope: {slope})',
        'rssi_power.graph_rssi_vs_power_label': 'RSSI vs Power',
        'rssi_power.graph_info_epc': 'EPC:',
        'rssi_power.graph_info_freq': 'Freq:',
        'rssi_power.graph_info_slope': 'Slope:',
        'rssi_power.graph_error': 'Erro ao gerar gráfico:',
        'rssi_power.success': 'Sucesso',
        'rssi_power.success_report_generated': 'Relatório PDF dos testes selecionados gerado com sucesso!\n\nArquivo: {filepath}\n\nTestes incluídos: {count}',
        'rssi_power.test_completed': 'Teste Concluído',
        'rssi_power.test_completed_msg': 'Varredura de potência concluída!',
        'rssi_power.test_error': 'Erro no Teste',
        'rssi_power.name_duplicate_inline': 'Nome Duplicado',
        'rssi_power.name_duplicate_inline_msg': 'Já existe um teste com o nome \'{name}\' no histórico.\n\nPor favor, escolha um nome diferente para este teste.',
        'rssi_power.no_test_selected_save': 'Nenhum Teste Selecionado',
        'rssi_power.no_test_selected_save_msg': 'Selecione um ou mais testes no histórico para salvar.',
        'rssi_power.save_tests_title': 'Salvar Testes Selecionados',
        'rssi_power.tests_saved_success': '{count} teste(s) salvos com sucesso.',
        'rssi_power.error_saving': 'Erro ao Salvar',
        'rssi_power.error_saving_msg': 'Não foi possível salvar.\n{error}',
        'rssi_power.import_tests_title': 'Importar Testes',
        'rssi_power.no_tests_in_file': 'Nenhum Teste Encontrado',
        'rssi_power.no_tests_in_file_msg': 'O arquivo não contém dados de teste válidos.',
        'rssi_power.import_completed': 'Importação Concluída',
        'rssi_power.import_completed_msg': '{count} teste(s) adicionado(s) ao histórico.',
        'rssi_power.import_error': 'Erro de Importação',
        'rssi_power.import_error_msg': 'Falha ao importar arquivo.\n{error}',
        'rssi_power.db_unavailable_report': 'Aviso',
        'rssi_power.db_unavailable_report_msg': 'Banco de dados não disponível para gerar relatório.',
        'rssi_power.no_test_selected_report': 'Nenhum Teste Selecionado',
        'rssi_power.no_test_selected_report_msg': 'Por favor, selecione um ou mais testes no histórico para gerar o relatório.',
        'rssi_power.error_generating_pdf': 'Erro',
        'rssi_power.error_generating_pdf_msg': 'Erro ao gerar relatório PDF:\n{error}',
        'rssi_power.error_unexpected_pdf': 'Erro ao gerar relatório PDF:\n{error}',
        'rssi_power.delete_tests_title': 'Nenhum Teste Selecionado',
        'rssi_power.delete_tests_msg': 'Selecione um ou mais testes no histórico para excluir.',
        'rssi_power.tests_deleted': 'Sucesso',
        'rssi_power.tests_deleted_msg': '{count} teste(s) excluídos.',
        'rssi_power.save_pdf_title': 'Salvar Relatório PDF',
        'rssi_power.no_valid_test': 'Aviso',
        'rssi_power.no_valid_test_msg': 'Nenhum teste válido encontrado entre os selecionados.',
        
        # Constant Power Module
        'constant_power.dll_error': 'Erro de DLL',
        'constant_power.dll_error_msg': 'O arquivo \'UHFRFID.dll\' não foi encontrado.',
        'constant_power.demo_mode': 'Modo Demo',
        'constant_power.demo_mode_msg': 'Este módulo está funcionando em modo demo.\n\nPara funcionalidade completa, adicione uma licença válida no módulo License.',
        'constant_power.safety_stop_temp': 'Parada de Segurança',
        'constant_power.safety_stop_temp_msg': 'Temperatura ({temp:.1f}°C) excedeu o limite de {limit}°C.\n\nO teste não pode ser iniciado por segurança do hardware.',
        'constant_power.reflected_power_high': 'Potência Refletida Alta',
        'constant_power.reflected_power_high_msg': 'Potência Refletida ({power:.1f} dBm) excedeu o limite de {limit} dBm.\n\nVerifique o sistema irradiante (antena).\nO teste não pode ser iniciado por segurança do hardware.',
        'constant_power.invalid_license': 'Licença Inválida',
        'constant_power.invalid_license_msg': 'Nenhuma licença ativa encontrada.\n\nPara usar este módulo, ative uma licença válida no módulo License.',
        'constant_power.hardware_unavailable': 'Erro',
        'constant_power.hardware_unavailable_msg': 'Hardware não está disponível. Teste cancelado.',
        'constant_power.freq_outside_license': 'Frequência fora das faixas da licença',
        'constant_power.freq_outside_license_msg': 'A frequência {freq} MHz está fora das faixas permitidas pela licença.\n\nFaixas permitidas: {allowed}\nFaixas excluídas: {excluded}\nFrequência digitada: {freq} MHz\n\nAjuste a frequência para dentro de uma das faixas permitidas, evitando as faixas excluídas.',
        'constant_power.power_outside_license': 'Potência fora dos limites da licença',
        'constant_power.power_outside_license_msg': 'A potência selecionada ({power} dBm) está fora dos limites permitidos pela licença.\n\nLimites permitidos: {min_power} - {max_power} dBm\nPotência selecionada: {power} dBm\n\nAjuste a potência para dentro da faixa permitida pela licença.',
        'constant_power.invalid_values': 'Erro',
        'constant_power.invalid_values_msg': 'Valores inválidos nos campos de entrada',
        'constant_power.error_starting': 'Erro',
        'constant_power.error_starting_msg': 'Erro ao iniciar teste: {error}',
        'constant_power.hardware_not_found': 'Erro',
        'constant_power.hardware_not_found_msg': 'Hardware não encontrado. Fechando.',
        
        # License Module
        'license.no_license_warning': 'Aviso',
        'license.no_license_warning_msg': 'Nenhuma licença para exibir.',
        'license.technical_sheet': 'Ficha Técnica',
        'license.export_title': 'Exportar Licença',
        'license.export_success': 'Sucesso',
        'license.export_success_msg': 'Licença exportada para:\n{path}',
        'license.export_error': 'Erro',
        'license.export_error_msg': 'Não foi possível salvar o arquivo.',
        'license.delete_no_device': 'Erro',
        'license.delete_no_device_msg': 'Nenhum dispositivo conectado.',
        'license.delete_success': 'Sucesso',
        'license.delete_success_msg': 'Licença deletada.',
        'license.delete_error': 'Erro',
        'license.delete_error_msg': 'Não foi possível deletar a licença.',
        'license.no_hardware_warning': 'Aviso',
        'license.no_hardware_warning_msg': 'Nenhum hardware detectado. Conecte um reader RFID primeiro.',
        'license.no_uid_warning': 'Aviso',
        'license.no_uid_warning_msg': 'Não foi possível ler o UID do dispositivo.',
        'license.authorization_title': 'Autorização',
        'license.authorization_prompt': 'Digite o seu Authorization Token:',
        'license.processing': 'Processando',
        'license.processing_msg': 'Tentando obter licença do servidor...',
        'license.register_success': 'Sucesso',
        'license.register_success_msg': 'Licença registrada!',
        'license.validation_error': 'Erro de Validação',
        'license.validation_error_msg': 'Token inválido: {msg}',
        'license.failure': 'Falha',
        'license.import_title': 'Importar Licença',
        'license.read_error': 'Erro',
        'license.read_error_msg': 'Falha ao ler o arquivo.',
        'license.invalid_license_error': 'Erro',
        'license.invalid_license_error_msg': 'Licença inválida: {msg}',
        'license.import_success': 'Sucesso',
        'license.import_success_msg': 'Licença importada com sucesso!',
        'license.device_mismatch': 'Erro',
        'license.device_mismatch_msg': 'A licença não corresponde a este dispositivo.',
        'license.unexpected_error': 'Erro',
        'license.unexpected_error_msg': 'Erro inesperado: {error}',
        'license.eula_not_found': 'Erro',
        'license.eula_not_found_msg': 'Arquivo EULA não encontrado:\n{path}',
        'license.eula_open_error': 'Erro',
        'license.eula_open_error_msg': 'Não foi possível abrir o arquivo EULA.pdf:\n{error}',
        'license.eula_unexpected_error': 'Erro',
        'license.eula_unexpected_error_msg': 'Erro inesperado ao abrir EULA: {error}',
        'license.test_standalone_error': 'Erro de Hardware',
        'license.test_standalone_error_msg': 'Hardware não encontrado. O teste isolado não pode continuar.',
        
        # Constant Power Module
        'constant_power.browser_mode': 'modo browser',
        'constant_power.test_config': 'Configuração do Teste',
        'constant_power.frequency_mhz': 'Frequência (MHz):',
        'constant_power.power_dbm': 'Potência (dBm):',
        'constant_power.controls': 'Controles',
        'constant_power.test': 'Testar',
        'constant_power.stop': 'Parar',
        'constant_power.pause': '⏸ Pausar',
        'constant_power.resume': '▶ Continuar',
        'constant_power.clear_graph': 'Limpar Gráfico',
        'constant_power.graph_title': 'Gráfico RSSI vs Tempo',
        
        # FastThreshold Module
        'fastthreshold.title': 'FastThreshold - Medição Rápida de Threshold',
        'fastthreshold.test_history': 'Histórico de Testes por Tag',
        'fastthreshold.graph_title': 'Gráfico de Threshold',
        'fastthreshold.statistics': 'Análise Estatística',
        'fastthreshold.safety_system': 'Sistema de Segurança',
        'fastthreshold.temperature': 'Temperatura:',
        'fastthreshold.vswr': 'VSWR:',
        'fastthreshold.test_config': 'Configuração do Teste',
        'fastthreshold.test_name': 'Nome do Teste:',
        'fastthreshold.freq_mhz': 'Freq (MHz)',
        'fastthreshold.threshold_dbm': 'Threshold (dBm)',
        'fastthreshold.test': 'Teste',
        'fastthreshold.testing': 'Testando...',
        'fastthreshold.test_button': 'Testar',
        'fastthreshold.clear': 'Limpar',
        'fastthreshold.save': 'Salvar',
        'fastthreshold.import': 'Importar',
        'fastthreshold.report_pdf': 'Relatório (PDF)',
        'fastthreshold.ready': 'Pronto para testar',
        'fastthreshold.testing_tag': 'Testando tag...',
        'fastthreshold.execution_summary': 'Resumo da Execução',
        'fastthreshold.tags_tested': 'Tags Testadas:',
        'fastthreshold.tags_selected': 'Tags Selecionadas:',
        'fastthreshold.select_all': 'Selecionar Todos',
        'fastthreshold.deselect_all': 'Deselecionar Todos',
        'fastthreshold.delete_selected': 'Excluir Selecionados',
        'fastthreshold.generate_stats': 'Gerar Estatística',
        'fastthreshold.export_excel': 'Exportar para Excel',
        'fastthreshold.plot': 'Plotar',
        'fastthreshold.tag_epc': 'EPC da Tag',
        'fastthreshold.date_time': 'Data/Hora',
        'fastthreshold.attention': '⚠️ ATENÇÃO: Condições críticas detectadas!',
        'fastthreshold.missing_dependency': 'Dependência Faltando',
        'fastthreshold.missing_dependency_msg': 'A biblioteca \'matplotlib\' não foi encontrada.\nPor favor, instale-a com o comando:\n\npy -m pip install matplotlib',
        'fastthreshold.dll_critical_error': 'Erro Crítico de DLL',
        'fastthreshold.dll_critical_error_msg': 'Não foi possível carregar a DLL \'{dll}\'.\nCertifique-se que o arquivo está na mesma pasta do programa.\n\nMotivo: {error}',
        'fastthreshold.demo_mode_title': 'Modo Demo',
        'fastthreshold.demo_mode_msg': 'Este módulo está funcionando em modo demo.\n\nPara funcionalidade completa, adicione uma licença válida no módulo License.',
        'fastthreshold.error': 'Erro',
        'fastthreshold.freq_not_allowed': 'Frequência {n} ({freq} MHz) não permitida pela licença',
        'fastthreshold.freq_invalid': 'Frequência {n} inválida',
        'fastthreshold.no_freq_configured': 'Configure pelo menos uma frequência',
        'fastthreshold.test_error': 'Erro no teste. Tente novamente',
        'fastthreshold.test_name_required': 'Por favor, digite um nome para o teste antes de iniciar.',
        'fastthreshold.mean': 'Média',
        'fastthreshold.mean_minus_3sigma': 'Média - 3σ',
        'fastthreshold.mean_plus_3sigma': 'Média + 3σ',
        'fastthreshold.freq_unit': '(MHz)',
        'fastthreshold.mean_unit': '(dBm)',
        'fastthreshold.sigma_unit': '(dBm)',
        'fastthreshold.freq_mhz_label': 'Frequência (MHz)',
        'fastthreshold.mean_dbm_label': 'Média (dBm)',
        'fastthreshold.mean_minus_3sigma_label': 'Média - 3σ (dBm)',
        'fastthreshold.mean_plus_3sigma_label': 'Média + 3σ (dBm)',
        'fastthreshold.sigma_dbm_label': 'σ (dBm)',
        'fastthreshold.threshold_dbm_label': 'Threshold (dBm)',
        'fastthreshold.statistical_analysis': 'Análise Estatística',
        'fastthreshold.duplicate_epc_title': 'EPC Duplicado',
        'fastthreshold.duplicate_epc_msg': 'A tag com EPC {epc} já foi testada anteriormente.\n\nEsta entrada será destacada em vermelho no histórico.',
        'fastthreshold.success': 'Sucesso',
        'fastthreshold.error_generic': 'Erro',
        'fastthreshold.report_saved': 'Relatório salvo em: {filename}',
        'fastthreshold.error_saving_report': 'Erro ao salvar relatório: {error}',
        'fastthreshold.save_report_title': 'Salvar Relatório',
        'fastthreshold.import_report_title': 'Importar Relatório',
        'fastthreshold.json_files': 'Arquivos JSON',
        'fastthreshold.all_files': 'Todos os arquivos',
        'fastthreshold.report_imported': 'Relatório importado com sucesso!',
        'fastthreshold.invalid_file': 'Arquivo não contém dados válidos',
        'fastthreshold.error_importing_report': 'Erro ao importar relatório: {error}',
        'fastthreshold.warning': 'Aviso',
        'fastthreshold.info': 'Info',
        'fastthreshold.no_tests_for_report': 'Nenhum teste no histórico para gerar relatório.',
        'fastthreshold.no_tests_selected_title': 'Nenhum Teste Selecionado',
        'fastthreshold.no_tests_selected_msg': 'Por favor, selecione um ou mais testes no histórico para gerar o relatório.',
        'fastthreshold.save_pdf_title': 'Salvar Relatório PDF',
        'fastthreshold.pdf_generated': 'Relatório PDF dos testes selecionados gerado com sucesso!\n\nArquivo: {filepath}\n\nTestes incluídos: {count}',
        'fastthreshold.error_generating_pdf': 'Erro ao gerar relatório PDF:\n{error}',
        'fastthreshold.unexpected_error': 'Erro inesperado ao gerar relatório:\n{error}',
        'fastthreshold.no_tests_to_delete': 'Nenhum teste no histórico para excluir',
        'fastthreshold.no_tests_selected_delete': 'Nenhum teste selecionado para excluir',
        'fastthreshold.confirm_delete_title': 'Confirmar Exclusão',
        'fastthreshold.confirm_delete_msg': 'Deseja realmente excluir {count} teste(s) selecionado(s)?\n\nEsta ação não pode ser desfeita.',
        'fastthreshold.tests_deleted': '{count} teste(s) excluído(s) com sucesso!',
        'fastthreshold.error_deleting_tests': 'Erro ao excluir testes: {error}',
        'fastthreshold.indeterminate_thresholds_title': '⚠️ Aviso - Thresholds Indeterminados',
        'fastthreshold.indeterminate_thresholds_msg': 'Foram detectados {count} threshold(s) indeterminado(s) nos testes selecionados.\n\nThresholds indeterminados: <5 dBm ou >25 dBm\n\nAção necessária: Remova as tags com threshold indeterminado antes de gerar a análise estatística.',
        'fastthreshold.no_data_for_stats': 'Nenhum dado selecionado para análise estatística',
        'fastthreshold.error_generating_stats': 'Erro ao gerar estatísticas: {error}',
        'fastthreshold.no_tests_to_export': 'Nenhum teste no histórico para exportar.',
        'fastthreshold.export_excel_title': 'Exportar para Excel',
        'fastthreshold.excel_files': 'Arquivos Excel',
        'fastthreshold.excel_2003': 'Excel 2003',
        'fastthreshold.openpyxl_not_found': 'Biblioteca \'openpyxl\' não encontrada.\nPor favor, instale com: pip install openpyxl',
        'fastthreshold.excel_exported': 'Dados exportados com sucesso para Excel!\n\nArquivo: {filepath}\n\nAbas incluídas:\n- Histórico de Testes\n- Análise Estatística',
        'fastthreshold.error_exporting_excel': 'Erro ao exportar para Excel:\n{error}',
        'fastthreshold.test_cancelled': 'Teste cancelado.',
        'fastthreshold.test_completed': 'Teste concluído! Pronto para testar outra tag',
        'fastthreshold.ready': 'Pronto para testar',
        'fastthreshold.generating_pdf': 'Gerando relatório PDF...',
        'fastthreshold.pdf_generated_success': 'Relatório PDF gerado com sucesso!',
        'fastthreshold.error_generating_pdf_status': 'Erro ao gerar relatório PDF',
        'fastthreshold.exporting_excel': 'Exportando para Excel...',
        'fastthreshold.excel_export_completed': 'Exportação concluída com sucesso!',
        'fastthreshold.error_exporting_excel_status': 'Erro ao exportar para Excel',
        'fastthreshold.attention_critical': '⚠️ ATENÇÃO: Condições críticas detectadas!',
        'fastthreshold.system_safe': '✅ Sistema seguro',
        'fastthreshold.pdf_files': 'Arquivos PDF',
        
        # Noise Check Module
        'noise.test_config': 'Configuração do Teste',
        'noise.name': 'Nome:',
        'noise.time_s': 'Tempo (s):',
        'noise.mode': 'Modo:',
        'noise.single': 'Único',
        'noise.continuous': 'Contínuo',
        'noise.controls': 'Controles',
        'noise.test': 'Testar',
        'noise.stop': 'Parar',
        'noise.clear_plot': 'Limpar Gráfico',
        'noise.save_selected': 'Salvar Selecionados',
        'noise.import_tests': 'Importar Testes',
        'noise.report_pdf': 'Relatório Selecionados (PDF)',
        'noise.test_history': 'Histórico de Testes',
        'noise.stats_loading': 'Estatísticas: Carregando...',
        'noise.plot': 'Plot',
        'noise.id': 'ID',
        'noise.test_name': 'Nome do Teste',
        'noise.duration': 'Duração (s)',
        'noise.avg_noise': 'Ruído Médio (dBm)',
        'noise.min_noise': 'Ruído Mínimo (dBm)',
        'noise.max_noise': 'Ruído Máximo (dBm)',
        'noise.max_noise_time': 'Hora Ruído Máximo',
        'noise.date_time': 'Data/Hora',
        'noise.severity': 'Severidade',
        'noise.select_all': 'Selecionar Todos',
        'noise.deselect_all': 'Deselecionar Todos',
        'noise.delete_selected': 'Excluir Selecionados...',
        'noise.stats_format': 'Estatísticas: {count} testes | Duração total: {duration:.1f}s | Ruído médio: {avg_noise:.1f} dBm',
        'noise.stats_format_single': 'Estatísticas: {count} teste | Duração total: {duration:.1f}s | Ruído médio: {avg_noise:.1f} dBm',
        'noise.stats_db_unavailable': 'Estatísticas: Banco de dados não disponível',
        'noise.stats_load_error': 'Estatísticas: Erro ao carregar ({error})',
        'noise.x_axis_label': 'Tempo (s)',
        'noise.y_axis_label': 'Intensidade (dBm)',
        'noise.severity_low': 'Baixa',
        'noise.severity_medium': 'Média',
        'noise.severity_high': 'Alta',
        'noise.severity_very_high': 'Muito Alta',
        'noise.severity_low_desc': 'Ruído estável, pouca variação - Ambiente ideal',
        'noise.severity_medium_desc': 'Variação moderada de ruído - Aceitável',
        'noise.severity_high_desc': 'Variação significativa de ruído - Pode afetar performance',
        'noise.severity_very_high_desc': 'Variação extrema de ruído - Operação comprometida',
        'noise.severity_help_title': 'Definição de Severidade do Ruído',
        'noise.severity_criteria_title': 'Critério de Classificação de Severidade',
        'noise.severity_formula': 'Severidade = Ruído Máximo - Ruído Médio',
        'noise.severity_info': '• Ruído Médio: Média aritmética de todos os valores coletados\n• Ruído Máximo: Maior valor registrado durante o teste\n• A classificação é aplicada automaticamente aos testes',
        
        # Antenna Check Module
        'antenna.test_config': 'Configuração do Teste',
        'antenna.name': 'Nome:',
        'antenna.power_dbm': 'Potência (dBm):',
        'antenna.graph': 'Gráfico:',
        'antenna.curve': 'Curva:',
        'antenna.frequency_mhz': 'Frequência (MHz):',
        'antenna.min': 'Min:',
        'antenna.max': 'Max:',
        'antenna.step_mhz': 'Passo (MHz):',
        'antenna.controls': 'Controles',
        'antenna.test': 'Testar',
        'antenna.stop': 'Parar',
        'antenna.clear_plot': 'Limpar Gráfico',
        'antenna.save_selected': 'Salvar Selecionados',
        'antenna.import_tests': 'Importar Testes',
        'antenna.report_pdf': 'Relatório Selecionados (PDF)',
        'antenna.test_history': 'Histórico de Testes',
        'antenna.stats_loading': 'Estatísticas: Carregando...',
        'antenna.plot': 'Plot',
        'antenna.name_col': 'Nome',
        'antenna.power': 'Pot (dBm)',
        'antenna.freq_range': 'Range Freq (MHz)',
        'antenna.min_return_loss': 'Min Return Loss (dBm)',
        'antenna.vswr': 'VSWR',
        'antenna.best_freq': 'Na Freq (MHz)',
        'antenna.date_time': 'Data/Hora',
        'antenna.select_all': 'Selecionar Todos',
        'antenna.deselect_all': 'Deselecionar Todos',
        'antenna.delete_selected': 'Excluir Selecionados...',
        'antenna.import_tests_dialog': 'Importar Testes de Antena',
        'antenna.save_tests_dialog': 'Salvar Testes Selecionados',
        'antenna.import_tests_title': 'Importar Testes',
        'antenna.save_pdf_title': 'Salvar Relatório PDF',
        'antenna.standalone_title': 'Teste Isolado - Módulo de Antena',
        'antenna.curve_point': 'Curva Pontual',
        'antenna.curve_smooth': 'Curva Suave',
        'antenna.stats_format': 'Estatísticas: {count} testes no histórico',
        'antenna.stats_format_single': 'Estatísticas: {count} teste no histórico',
        'antenna.x_axis_label': 'Frequência (MHz)',
        'antenna.y_axis_return_loss': 'Return Loss (dBm)',
        'antenna.y_axis_vswr': 'VSWR',
        'antenna.y_axis_impedance': 'Impedância (Ω)',
        'antenna.y_axis_return_loss': 'Return Loss (dB)',
        'antenna.y_axis_vswr': 'VSWR',
        
        # FastSurance Module
        'fastsurance.title': 'Controle e Relatório de Leitor RFID',
        'fastsurance.safety_system': 'Sistema de Segurança',
        'fastsurance.temperature': 'Temperatura:',
        'fastsurance.vswr': 'VSWR:',
        'fastsurance.epc_filter': 'Filtro por EPC',
        'fastsurance.tag_registration': '🔍 Registro de Tag',
        'fastsurance.scanning': '🔍 Inventariando...',
        'fastsurance.selected_epc': 'EPC / RSSI Selecionado:',
        'fastsurance.click_to_load': 'Clique em \'Registro de Tag\' para carregar',
        'fastsurance.no_epc_selected': 'Nenhum EPC selecionado',
        'fastsurance.license_required': '⚠ Licença necessária para Threshold',
        'fastsurance.test_type': 'Tipo de Teste',
        'fastsurance.gonogo': 'Go/NoGo',
        'fastsurance.threshold': 'Threshold',
        'fastsurance.use_attenuator': 'Use atenuador',
        'fastsurance.test_config': 'Configuração do Teste',
        'fastsurance.freq_mhz': 'Freq (MHz)',
        'fastsurance.threshold_dbm': 'Threshold (dBm)',
        'fastsurance.test': 'Teste',
        'fastsurance.start_execution': 'Iniciar Execução',
        'fastsurance.testing': 'Testar',
        'fastsurance.checking': 'Verificando...',
        'fastsurance.clear': 'Limpar',
        'fastsurance.save': 'Salvar',
        'fastsurance.import': 'Importar',
        'fastsurance.import_from_threshold': 'Importar do Threshold',
        'fastsurance.report_pdf': 'Relatório (PDF)',
        'fastsurance.execution_summary': 'Resumo da Execução',
        'fastsurance.tags_tested': 'Tags Testadas:',
        'fastsurance.approved': 'Aprovados:',
        'fastsurance.rejected': 'Reprovados:',
        'fastsurance.yield': 'Yield (%):',
        'fastsurance.graph': 'Gráfico',
        'fastsurance.test_history': 'Histórico de Testes',
        'fastsurance.last_test': 'Último Teste',
        'fastsurance.failure_distribution': 'Distribuição de Falhas por Teste',
        'fastsurance.pareto_chart': 'Gráfico de Pareto das Falhas',
        'fastsurance.browser_mode': ' modo browser',
        'fastsurance.no_tags_found': 'Nenhuma tag encontrada',
        'fastsurance.epc_selected': 'EPC selecionado',
        'fastsurance.epc_column': 'EPC da Tag',
        'fastsurance.result_column': 'Resultado Geral',
        'fastsurance.failures_column': 'Falhas (MHz)',
        'fastsurance.datetime_column': 'Data/Hora',
        'fastsurance.passed': 'PASSOU',
        'fastsurance.failed': 'REPROVADO',
        'fastsurance.test': 'Teste',
        'fastsurance.number_of_failures': 'Número de Falhas',
        'fastsurance.accumulated': 'Acumulado (%)',
        'fastsurance.accumulated_percent': 'Percentual Acumulado (%)',
        'fastsurance.frequency_label': 'Frequência (MHz)',
        'fastsurance.threshold_label': 'Threshold (dBm)',
        'fastsurance.test_number': 'Teste {n}',
        'fastsurance.freq_number': 'Frequência {n}',
        'fastsurance.no_epc_selected_msg': 'Selecione um EPC para o teste.',
        'fastsurance.no_test_config': 'Nenhum teste configurado.',
        'fastsurance.no_reference_tag': 'Não foi possível encontrar uma tag de referência para o teste.',
        'fastsurance.temp_critical': 'Temperatura crítica: {temp}°C. Teste bloqueado por segurança do hardware.',
        'fastsurance.reflected_power_high': 'Potência Refletida Alta: {power} dBm. Verifique o sistema irradiante.',
        'fastsurance.comm_error_reflected': 'Falha na comunicação inicial: Potência Refletida',
        'fastsurance.comm_error_temp': 'Falha na comunicação inicial: Temperatura',
        'fastsurance.heating_failed': 'Falha na execução do ciclo de aquecimento',
        'fastsurance.validation_error_freq': 'Teste {n}: Frequência {freq} MHz fora das faixas permitidas pela licença.\n\nFaixas permitidas: {ranges}\nFaixas excluídas: {excluded}\nFrequência tentada: {freq} MHz',
        'fastsurance.validation_error_power': 'Teste {n}: Potência {power}dBm fora dos limites da licença ({min}-{max}dBm).',
        'fastsurance.validation_error_freq_invalid': 'Teste {n}: Frequência inválida.',
        'fastsurance.validation_error_freq_threshold': 'Frequência {n}: {freq}MHz fora das faixas permitidas pela licença.\n\nFaixas permitidas: {ranges}\nFaixas excluídas: {excluded}\nFrequência tentada: {freq} MHz',
        'fastsurance.validation_error_freq_threshold_invalid': 'Frequência {n}: Inválida.',
        'fastsurance.clear_confirm': 'Você tem certeza que deseja limpar a CONFIGURAÇÃO e os DADOS de relatório desta tela?',
        'fastsurance.no_data_to_save': 'Não há dados para salvar.',
        'fastsurance.save_success': 'Relatório salvo com sucesso em:\n{path}',
        'fastsurance.save_error': 'Ocorreu um erro ao tentar salvar o arquivo.\n\nDetalhes: {error}',
        'fastsurance.select_report': 'Selecionar relatório',
        'fastsurance.read_error': 'Não foi possível ler o arquivo.\n\nDetalhes: {error}',
        'fastsurance.invalid_file': 'O arquivo não é um relatório válido.',
        'fastsurance.import_confirm': 'Isso substituirá os dados atuais. Deseja continuar?',
        'fastsurance.import_success_tags': 'Relatório de \'Testes de Tags\' importado.',
        'fastsurance.import_success_threshold': 'Relatório de \'Threshold\' importado.',
        'fastsurance.import_error': 'Ocorreu um erro ao processar o relatório.\n\nDetalhes: {error}',
        'fastsurance.no_threshold_data': 'Nenhum dado de threshold disponível para gerar relatório.',
        'fastsurance.no_tags_selected': 'Nenhuma tag selecionada para o relatório.',
        'fastsurance.pdf_success': 'Relatório PDF do threshold gerado com sucesso!\n\nArquivo: {path}',
        'fastsurance.pdf_error': 'Erro ao gerar relatório PDF:\n{error}',
        'fastsurance.demo_mode': 'Este módulo está funcionando em modo demo.\n\nPara funcionalidade completa, adicione uma licença válida no módulo License.',
        'fastsurance.use_attenuator': 'Use atenuador',
        'fastsurance.no_threshold_to_migrate': 'Nenhum resultado de threshold para migrar.',
        'fastsurance.migrate_confirm': 'Isso irá sobrescrever os valores atuais de Frequência e Potência. Deseja continuar?',
        'fastsurance.migrate_success': 'Dados do teste de threshold migrados com sucesso.',
        'fastsurance.invalid_threshold': 'Não foi possível determinar o threshold.\n\nValores encontrados estão fora do range válido:\n• Mínimo: {min} dBm\n• Máximo: {max} dBm\n\nExecute novamente o teste de threshold para obter valores válidos.',
        'fastsurance.no_tags_test_data': 'Nenhum dado de teste de tags disponível para gerar relatório.',
        'fastsurance.missing_dependency': 'Dependência Faltando',
        'fastsurance.missing_dependency_msg': 'A biblioteca \'matplotlib\' não foi encontrada.\nPor favor, instale-a com o comando:\n\npy -m pip install matplotlib',
        'fastsurance.dll_critical_error': 'Erro Crítico de DLL',
        'fastsurance.dll_critical_error_msg': 'Não foi possível carregar a DLL \'{dll}\'.\nCertifique-se que o arquivo está na mesma pasta do programa.\n\nMotivo: {error}',
        'fastsurance.error': 'Erro',
        'fastsurance.help_file_not_found': 'Arquivo de ajuda \'{file}\' não encontrado.',
        'fastsurance.demo_mode_title': 'Modo Demo',
        'fastsurance.success': 'Sucesso',
        'fastsurance.save_report_title': 'Salvar Relatório PDF',
        'fastsurance.tags_pdf_success': 'Relatório PDF dos testes de tags gerado com sucesso!\n\nArquivo: {path}',
        'fastsurance.pdf_generation_error': 'Erro ao gerar relatório PDF:\n{error}',
        'fastsurance.unknown_error': 'Erro desconhecido',
        
        # Threshold Module
        'threshold.x_axis_label': 'Frequência (MHz)',
        'threshold.test': 'Teste',
        'threshold.y_axis_module_power': 'Potência do Módulo (dBm)',
        'threshold.y_axis_module_rssi': 'RSSI do Módulo (dBm)',
        'threshold.y_axis_irradiated_power': 'Potência Irradiada (dBm)',
        'threshold.y_axis_backscatter': 'Backscatter (dBm)',
        'threshold.y_axis_power_tag_forward': 'Potência na Tag Forward (dBm)',
        'threshold.y_axis_power_tag_reversed': 'Potência na Tag Reversed (dBm)',
        'threshold.y_axis_conversion_loss': 'Perda de Conversão (dBm)',
        'threshold.y_axis_max_fcc_link_forward': 'Link FCC Máximo Forward (m)',
        'threshold.y_axis_max_fcc_link_reversed': 'Link FCC Máximo Reversed (m)',
        'threshold.y_axis_rcs': 'RCS (dBm²)',
        # Valores para dropdowns de tipo de gráfico
        'threshold.graph_type_module_power': 'Potência do Módulo (dBm)',
        'threshold.graph_type_module_rssi': 'RSSI do Módulo (dBm)',
        'threshold.graph_type_irradiated_power': 'Potência Irradiada (dBm)',
        'threshold.graph_type_backscatter': 'Backscatter (dBm)',
        'threshold.graph_type_power_tag_forward': 'Potência na Tag Forward (dBm)',
        'threshold.graph_type_power_tag_reversed': 'Potência na Tag Reversed (dBm)',
        'threshold.graph_type_conversion_loss': 'Perda de Conversão (dBm)',
        'threshold.graph_type_max_fcc_link_forward': 'Link FCC Máximo Forward (m)',
        'threshold.graph_type_max_fcc_link_reversed': 'Link FCC Máximo Reversed (m)',
        'threshold.graph_type_rcs': 'RCS (dBm²)',
        'threshold.no_tags_registered': '(Nenhuma tag registrada)',
        'threshold.failed': 'FALHOU',
        'threshold.safety_system': 'Sistema de Segurança',
        'threshold.temperature': 'Temperatura:',
        'threshold.vswr': 'VSWR:',
        'threshold.browser_mode': 'modo browser',
        'threshold.register_new_tags': '+ Registrar Novas Tags',
        'threshold.import_tag_json': '+ Importar Tag de arquivo JSON',
        'threshold.select_all_tags': '+ Selecionar Todas as Tags',
        'threshold.deselect_all_tags': '+ Desselecionar Todas as Tags',
        'threshold.erase_selected_tags': '- Excluir Tags Selecionadas',
        'threshold.save_selected_tags': '> Salvar Tags Selecionadas (JSON)',
        'threshold.registered_tags': 'Tags Registradas',
        'threshold.project': 'Projeto',
        'threshold.saved': 'salvo com sucesso',
        'threshold.deleted': 'deletado com sucesso',
        'threshold.file': 'Arquivo',
        'threshold.tags': 'Tags',
        'threshold.tests': 'Testes',
        'threshold.cleared': 'Limpas',
        'threshold.parameters': 'Parâmetros',
        'threshold.reset': 'Resetados',
        'threshold.project_name': 'Nome:',
        'threshold.client': 'Cliente:',
        'threshold.save': 'Salvar',
        'threshold.clear': 'Limpar',
        'threshold.import': 'Importar',
        'threshold.test_config': 'Configuração do Teste',
        'threshold.freq_mhz': 'Freq. (MHz):',
        'threshold.to': 'to',
        'threshold.power_dbm': 'Potência (dBm):',
        'threshold.freq_step': 'Passo Freq. (MHz):',
        'threshold.power_step': 'Passo Potência (dBm):',
        'threshold.distance': 'Distância (m):',
        'threshold.attenuator': 'Atenuador (dB):',
        'threshold.description': 'Descrição:',
        'threshold.start_test': 'Start Test',
        'threshold.cancel_test': 'Cancelar Teste',
        'threshold.show_table': 'Mostrar Tabela',
        'threshold.pdf_report': 'Relatório Selecionados (PDF)',
        'threshold.test_history': 'Histórico de Testes',
        'threshold.tests_count': '({count} testes)',
        'threshold.test_count_single': '({count} teste)',
        'threshold.plot': 'Plot ↕',
        'threshold.test_name': 'Nome do Teste ✏️ ↕',
        'threshold.epc': 'EPC ↕',
        'threshold.attenuator_col': 'Atenuador ↕',
        'threshold.distance_col': 'Distância ↕',
        'threshold.date_time': 'Data/Hora ↕',
        'threshold.time': 'Tempo (s) ↕',
        'threshold.multiple_tests_title': 'Múltiplos Testes Marcados',
        'threshold.multiple_tests_msg': 'Existem {count} testes marcados para gráficos.\n\nPara mostrar a tabela de um teste específico:\n1. Clique na coluna \'Descrição\' do teste desejado no histórico\n2. O teste será destacado em azul\n3. Clique em \'Mostrar Tabela\' novamente\n\nTestes marcados:\n{marked_list}\n\nDeseja desmarcar todos os testes para começar do zero?',
        'threshold.no_test_selected_title': 'Nenhum Teste Selecionado',
        'threshold.no_test_selected_msg': 'Por favor, selecione um teste para mostrar sua tabela.\n\nPara selecionar um teste:\n1. Clique na coluna \'Descrição\' do teste desejado no histórico\n2. O teste será destacado em azul\n3. Clique em \'Mostrar Tabela\' novamente\n\nOU\n\n1. Marque um teste no checkbox ☐ da coluna \'Plot\' do histórico\n2. O checkbox deve mudar para ☑\n3. Clique em \'Mostrar Tabela\' (se for o único marcado)',
        'threshold.no_results_title': 'Sem Resultados',
        'threshold.no_results_msg': 'O teste \'{test_desc}\' não possui resultados para mostrar.\n\nPossíveis causas:\n• Teste foi interrompido antes de completar\n• Erro durante a execução do teste\n• Dados corrompidos no banco',
        'threshold.yes': 'Sim',
        'threshold.no': 'Não',
        'threshold.select_an_action': 'Selecionar uma ação',
        # Valores para dropdown de ações da tabela
        'threshold.table_select_all': 'Selecionar Todos os Testes',
        'threshold.table_deselect_all': 'Deselecionar Todos os Testes',
        'threshold.table_statistical': 'Cálculo Estatístico dos Selecionados',
        'threshold.table_delete_selected': 'Excluir Testes Selecionados',
        'threshold.table_export_excel': 'Exportar Selecionados para Excel',
        'threshold.error': 'Erro',
        'threshold.error_invalid_parameters': 'Parâmetros inválidos. Verifique os valores numéricos.',
        'threshold.error_hardware': 'Erro de Hardware',
        'threshold.error_hardware_not_detected': 'Hardware não detectado.',
        'threshold.error_hardware_connection': 'Erro ao conectar hardware (COM{port})\nVerifique a conexão.',
        'threshold.error_hardware_init': 'Erro na inicialização: {error}',
        'threshold.error_hardware_port': 'Erro ao abrir a porta COM{port}',
        'threshold.error_hardware_port_exception': 'Exceção ao abrir porta COM: {error}',
        'threshold.warning_hardware': 'Hardware',
        'threshold.warning_matplotlib': 'Matplotlib Faltando',
        'threshold.warning_matplotlib_msg': 'Instale \'matplotlib\' com: pip install matplotlib',
        'threshold.warning_db_unavailable': 'Banco de dados não disponível para gerar relatório.',
        'threshold.warning_no_test_selected_report': 'Nenhum Teste Selecionado',
        'threshold.warning_no_test_selected_report_msg': 'Por favor, selecione um ou mais testes no histórico para gerar o relatório.',
        'threshold.warning_no_valid_test': 'Nenhum teste válido encontrado entre os selecionados.',
        'threshold.success': 'Sucesso',
        'threshold.success_report_generated': 'Relatório PDF dos testes selecionados gerado com sucesso!\n\nArquivo: {filepath}\n\nTestes incluídos: {count}',
        'threshold.error_generating_pdf': 'Erro ao gerar relatório PDF:\n{error}',
        'threshold.error_unexpected_report': 'Erro inesperado ao gerar relatório:\n{error}',
        'threshold.error_invalid_json': 'Formato de arquivo JSON inválido.\n\nTipo encontrado: {type}\nEsperado: lista de tags ou objeto com propriedade \'tags\'.\n\nConteúdo: {content}...',
        'threshold.error_reading_file': 'Erro de Leitura',
        'threshold.error_reading_file_msg': 'Não foi possível ler o arquivo:\n{error}',
        'threshold.info_import_summary': 'Resumo da Importação',
        'threshold.warning_no_selection': 'Nenhuma Seleção',
        'threshold.warning_no_selection_msg': 'Por favor, selecione pelo menos uma tag para remover.',
        'threshold.success_tags_removed': '{count} tag(s) removida(s) com sucesso.',
        'threshold.warning_some_tags_not_removed': 'Aviso',
        'threshold.warning_some_tags_not_removed_msg': '{removed} de {total} tag(s) foram removidas.\nAlgumas tags podem não ter sido encontradas no banco de dados.',
        'threshold.warning_no_selection_save': 'Por favor, selecione pelo menos uma tag para salvar.',
        'threshold.success_tags_saved': '{count} tag(s) salva(s) com sucesso em:\n{filepath}',
        'threshold.error_saving_file': 'Erro ao salvar arquivo:\n{error}',
        'threshold.info_test_selected': 'Teste Selecionado',
        'threshold.test_selected': 'Teste selecionado',
        'threshold.test_selected_msg': 'Agora você pode clicar em \'Mostrar Tabela\' ou usar \'Ver Tabela Diretamente\'.',
        'threshold.warning_no_results': 'Sem Resultados',
        'threshold.error_showing_table': 'Erro ao mostrar tabela: {error}',
        'threshold.success_tag_deleted': 'Tag deleted successfully.',
        'threshold.error_deleting_tag': 'Could not delete the tag from the database.',
        'threshold.warning_project_name': 'Nome do Projeto',
        'threshold.warning_project_name_msg': 'Por favor, insira um nome para o projeto.',
        'threshold.success_project_saved': 'Projeto Salvo',
        'threshold.error_saving_project': 'Erro ao salvar o projeto: {error}',
        'threshold.warning_no_project_selected_delete': 'Projeto',
        'threshold.warning_no_project_selected_delete_msg': 'Nenhum projeto selecionado para deletar.',
        'threshold.success_project_deleted': 'Projeto Deletado',
        'threshold.error_deleting_project': 'Erro ao deletar o projeto.',
        'threshold.error_deleting_project_exception': 'Erro ao deletar o projeto: {error}',
        'threshold.error_invalid_file': 'Arquivo Inválido',
        'threshold.error_invalid_file_msg': 'O arquivo não contém um projeto válido.',
        'threshold.success_project_imported': 'Projeto Importado',
        'threshold.error_file_not_found': 'Arquivo não encontrado.',
        'threshold.error_invalid_json_file': 'Arquivo JSON inválido.',
        'threshold.error_importing_project': 'Erro ao importar projeto: {error}',
        'threshold.warning_no_project_selected_export': 'Nenhum projeto selecionado para exportar.',
        'threshold.error_project_not_found': 'Projeto \'{name}\' não encontrado no banco de dados.',
        'threshold.success_project_exported': 'Projeto Exportado',
        'threshold.success_project_exported_msg': 'Projeto \'{project_name}\' exportado com sucesso!\n\nArquivo: {filename}\n[DATA] Tags: {tags_count}\n[INFO] Testes: {tests_count}',
        'threshold.error_exporting_project': 'Erro ao exportar projeto: {error}',
        'threshold.success_project_imported_msg': '[OK] PROJETO IMPORTADO COM SUCESSO!\n\n[DATA] Nome: {project_name}\n👤 Cliente: {client_name}\n[DATA] Tags: {tags_imported}\n[INFO] Testes: {tests_imported}\n⚙️ Configurações: Atualizadas\n📁 Origem: {filename}\n\n[OK] As tags importadas foram automaticamente selecionadas!',
        'threshold.not_specified': 'Não especificado',
        'threshold.no_results': 'Sem Resultados',
        'threshold.no_results_msg': 'O teste \'{test_desc}\' não possui resultados.',
        'threshold.save_completed': 'Salvamento Concluído',
        'threshold.save_completed_msg': 'Resultados salvos em: {filename}',
        'threshold.error_saving_results': 'Erro ao Salvar',
        'threshold.error_saving_results_msg': 'Erro ao salvar resultados: {error}',
        'threshold.warning_browser_mode': 'Modo Browser',
        'threshold.warning_browser_mode_msg': 'Função de teste indisponível sem licença ativa.',
        'threshold.warning_no_selection_test': 'Nenhuma Seleção',
        'threshold.warning_no_selection_test_msg': 'Por favor, selecione exatamente uma tag para testar.',
        'threshold.warning_multiple_tags': 'Múltiplas Tags',
        'threshold.warning_multiple_tags_msg': 'Por favor, selecione apenas uma tag para o teste de threshold.',
        'threshold.error_tag_not_found': 'Tag selecionada não encontrada.',
        'threshold.info_no_test_cancel': 'Informação',
        'threshold.info_no_test_cancel_msg': 'Nenhum teste está em execução para cancelar.',
        'threshold.error_license_limit': 'Limite de Licença',
        'threshold.error_hardware_connect': 'Erro de Hardware',
        'threshold.error_hardware_connect_msg': 'Não foi possível abrir a porta COM{port}',
        'threshold.error_hardware_init': 'Erro de Hardware',
        'threshold.error_hardware_init_msg': 'Exceção ao abrir porta COM: {error}',
        'threshold.selections_cleared': 'Seleções Limpas',
        'threshold.selections_cleared_msg': 'Todas as seleções de testes foram limpas com sucesso!\n\n• {count} testes desmarcados\n• Interface sincronizada\n• Gráficos atualizados',
        'threshold.error_test_not_found': 'Erro',
        'threshold.error_test_not_found_msg': 'Teste com ID {id} não encontrado.',
        'threshold.error_description_empty': 'Descrição Vazia',
        'threshold.error_description_empty_msg': 'Por favor, insira uma descrição válida para o teste.',
        'threshold.error_test_not_found_select': 'Erro',
        'threshold.error_test_not_found_select_msg': 'Teste não encontrado para seleção.',
        'threshold.error_invalid_attenuator': 'Valor Inválido',
        'threshold.error_invalid_attenuator_msg': 'Por favor, insira um valor numérico válido para o atenuador.',
        'threshold.error_invalid_distance': 'Valor Inválido',
        'threshold.error_invalid_distance_msg': 'Por favor, insira um valor numérico válido para a distância.',
        'threshold.export_completed': 'Exportação Concluída',
        'threshold.export_completed_msg': 'Dados exportados para: {filename}',
        'threshold.export_error': 'Erro na Exportação',
        'threshold.export_error_msg': 'Erro ao exportar dados: {error}',
        'threshold.no_test_selected_average': 'Nenhum Teste Selecionado',
        'threshold.no_test_selected_average_msg': 'Por favor, selecione pelo menos um teste para calcular a média.',
        'threshold.only_one_test': 'Apenas 1 Teste',
        'threshold.only_one_test_msg': 'É necessário pelo menos 2 testes para calcular a média.',
        'threshold.error_no_freq': 'Erro',
        'threshold.error_no_freq_msg': 'Nenhuma frequência válida encontrada nos testes selecionados.',
        'threshold.error_save_average': 'Erro',
        'threshold.error_save_average_msg': 'Falha ao salvar média no banco de dados',
        'threshold.average_calculated': 'Média Calculada',
        'threshold.average_calculated_msg': 'Média de {count} testes calculada e adicionada ao histórico!',
        'threshold.no_test_selected_statistics': 'Nenhum Teste Selecionado',
        'threshold.no_test_selected_statistics_msg': 'Por favor, selecione pelo menos um teste para análise estatística.',
        'threshold.statistics_complete': 'Análise Estatística Completa Concluída',
        'threshold.statistics_complete_msg': 'Análise estatística completa de {count} testes concluída!\n\n[OK] {success}/4 testes criados:\n• Média de {count} testes\n• Desvio Padrão de {count} testes\n• Limite Mínimo de {count} testes\n• Limite Máximo de {count} testes\n\nTodos podem ser plotados nos gráficos quando selecionados!',
        'threshold.error_save_statistics': 'Erro',
        'threshold.error_save_statistics_msg': 'Falha ao salvar todos os testes estatísticos no banco de dados',
        'threshold.invalid_selection_edit': 'Seleção Inválida',
        'threshold.invalid_selection_edit_msg': 'Por favor, selecione exatamente 1 teste para editar a descrição.',
        'threshold.error_create_dir': 'Erro',
        'threshold.error_create_dir_msg': 'Não foi possível criar o diretório:\n{error}',
        'threshold.save_completed': 'Salvamento Concluído',
        'threshold.import_completed': 'Importação Concluída',
        'threshold.import_completed_msg': '{imported} de {total} teste(s) importado(s) com sucesso!\nTotal de testes no histórico: {history_count}',
        'threshold.error_import': 'Erro na Importação',
        'threshold.error_import_msg': 'Erro ao importar testes: {error}',
        'threshold.invalid_file': 'Arquivo Inválido',
        'threshold.invalid_file_msg': 'O arquivo não contém dados de teste válidos.',
        'threshold.error_freq_min_max': 'Erro',
        'threshold.error_freq_min_max_msg': 'Frequência mínima deve ser menor que a máxima.',
        'threshold.error_steps': 'Erro',
        'threshold.error_steps_msg': 'Passos devem ser maiores que zero.',
        'threshold.settings_applied': 'Configurações Aplicadas',
        'threshold.settings_applied_msg': 'Configurações atualizadas com sucesso!',
        'threshold.error_invalid_values': 'Erro',
        'threshold.error_invalid_values_msg': 'Por favor, insira valores numéricos válidos.',
        'threshold.safety_check_failed': 'Verificação de Segurança Falhou',
        'threshold.safety_check_failed_msg': 'A verificação pré-teste de segurança falhou:\n\n{error}\n\nO teste não pode ser executado por questões de segurança.',
        'threshold.safety_stop': 'Parada de Segurança',
        'threshold.safety_stop_msg': 'Teste interrompido por segurança:\n{reason}',
        'threshold.error_license_limit': 'Limite de Licença',
        'threshold.error_license_limit_msg': '{message}',
        'threshold.error_save_no_tests': 'Erro no Salvamento',
        'threshold.error_save_no_tests_msg': 'Nenhum teste foi salvo. Verifique os logs.',
        'threshold.no_test_selected_export': 'Nenhum Teste Selecionado',
        'threshold.no_test_selected_export_msg': 'Por favor, selecione pelo menos um teste usando as checkboxes da tabela.',
        'threshold.no_test_selected_save': 'Nenhum Teste Selecionado',
        'threshold.no_test_selected_save_msg': 'Por favor, selecione pelo menos um teste para salvar.',
        'threshold.error_library_required': 'Biblioteca Necessária',
        'threshold.error_library_required_msg': 'Para exportar para Excel, instale:\n\npip install openpyxl pandas\n\nErro: {error}',
        'threshold.error_export_excel': 'Erro na Exportação',
        'threshold.error_export_excel_msg': 'Erro ao exportar para Excel:\n{error}',
        'threshold.error_invalid_file_list': 'Arquivo Inválido',
        'threshold.error_invalid_file_list_msg': 'O arquivo deve conter uma lista de testes.',
        'threshold.error_load_data': 'Erro',
        'threshold.error_load_data_msg': 'Erro ao carregar os dados de teste.',
        'threshold.error_load_data_exception': 'Erro na Carga',
        'threshold.error_load_data_exception_msg': 'Erro ao carregar dados: {error}',
        'threshold.save_success_detail': '{count} teste(s) salvo(s) com sucesso!\n\nDiretório: {dir}\n\nArquivos salvos:\n{files}',
        'threshold.export_excel_success': 'Banco de dados completo exportado!\n\nTestes: {count}\nLinhas de dados: {rows}\nArquivo: {filename}',
        'threshold.import_success_detail': '{imported} de {total} teste(s) importado(s) com sucesso!\nTotal de testes no histórico: {history_count}',
        'threshold.data_loaded_success': 'Dados Carregados',
        'threshold.data_loaded_success_msg': 'Resultados de teste carregados com sucesso!',
        'threshold.error_steps_msg': 'Passos devem ser maiores que zero.',
        'threshold.error_min_freq_below': 'Frequência mínima {freq} MHz está abaixo do limite da licença ativa.\n\nLicença permite: {min_allowed} a {max_allowed} MHz\nPor favor, insira um valor entre {min_allowed} e {max_allowed} MHz.',
        'threshold.error_min_freq_above': 'Frequência mínima {freq} MHz está acima do limite da licença ativa.\n\nLicença permite: {min_allowed} a {max_allowed} MHz\nPor favor, insira um valor entre {min_allowed} e {max_allowed} MHz.',
        'threshold.error_max_freq_above': 'Frequência máxima {freq} MHz está acima do limite da licença ativa.\n\nLicença permite: {min_allowed} a {max_allowed} MHz\nPor favor, insira um valor entre {min_allowed} e {max_allowed} MHz.',
        'threshold.error_max_freq_below': 'Frequência máxima {freq} MHz está abaixo do limite da licença ativa.\n\nLicença permite: {min_allowed} a {max_allowed} MHz\nPor favor, insira um valor entre {min_allowed} e {max_allowed} MHz.',
        'threshold.error_invalid_value': 'Valor Inválido',
        
        # PDF Report Translations
        'pdf.report_title_threshold': 'Relatório de Testes - Threshold',
        'pdf.system_info': 'Informações do Sistema',
        'pdf.software': 'Software:',
        'pdf.hardware': 'Hardware:',
        'pdf.firmware': 'Firmware:',
        'pdf.serial_number': 'Serial Number:',
        'pdf.license': 'Licença:',
        'pdf.generated_at': 'Gerado em:',
        'pdf.test_description_title': 'Descrição do Teste',
        'pdf.test_description_text': 'Este relatório contém os resultados dos testes de threshold realizados pelo FastChecker II. Os testes avaliam a sensibilidade do sistema RFID através da análise da relação entre potência de transmissão e taxa de leitura das tags, fornecendo dados essenciais para otimização do desempenho do sistema RFID.',
        'pdf.test_configuration': 'Configuração do Teste',
        'pdf.min_frequency': 'Frequência Mínima:',
        'pdf.max_frequency': 'Frequência Máxima:',
        'pdf.max_power': 'Potência Máxima:',
        'pdf.freq_step': 'Passo de Frequência:',
        'pdf.power_step': 'Passo de Potência:',
        'pdf.distance': 'Distância:',
        'pdf.attenuator': 'Atenuador:',
        'pdf.test_summary': 'Resumo dos Testes',
        'pdf.plot': 'Plot',
        'pdf.test_name': 'Nome do Teste',
        'pdf.epc': 'EPC',
        'pdf.attenuator_col': 'Atenuador',
        'pdf.distance_col': 'Distância',
        'pdf.date_time': 'Data/Hora',
        'pdf.duration': 'Tempo (s)',
        'pdf.test_charts': 'Gráficos dos Testes',
        'pdf.chart_error': '(Erro na geração)',
        'pdf.chart_unavailable': 'Não foi possível gerar o gráfico.',
        'pdf.no_data_available': 'Nenhum dado disponível para este tipo de gráfico',
        'pdf.additional_info': 'Informações Adicionais',
        'pdf.footer_text': 'Este relatório foi gerado automaticamente pelo FastChecker II.<br/>Sistema de análise e teste RFID profissional.<br/>Para suporte técnico, consulte a documentação do sistema.',
        'pdf.document_generated_at': 'Documento gerado em:',
        'pdf.etsi_band': 'ETSI 865-868 MHz',
        'pdf.anatel_band_1': 'ANATEL 902-907 MHz',
        'pdf.anatel_band_2': 'ANATEL 915.5-928 MHz',
        # Orientation Report
        'orientation.report_title': 'Relatório - Fast Orientation',
        'orientation.tests_summary': 'Resumo dos Testes Selecionados',
        'orientation.no_tests': 'Nenhum teste selecionado no banco de dados.',
        'orientation.polar_chart_title': 'Gráfico Polar Atual',
        'orientation.test_details_title': 'Detalhes do Teste: {name}',
        'orientation.detail.epc_line': '<b>EPC:</b> {value}',
        'orientation.detail.angle_range_line': '<b>Faixa de Ângulo:</b> {start}° a {end}°',
        'orientation.detail.step_line': '<b>Step:</b> {value}°',
        'orientation.detail.frequency_line': '<b>Frequência:</b> {value} MHz',
        'orientation.detail.timestamp_line': '<b>Data/Hora:</b> {value}',
        'orientation.detail.points_line': '<b>Total de medições:</b> {value}',
        'orientation.detail.angular_opening_line': '<b>Abertura Angular:</b> {value}',
        'orientation.detail.main_lobe_line': '<b>Direção Lobular:</b> {value}',
        'orientation.no_measurements': 'Sem medições registradas para este teste.',
        'orientation.live_section_title': 'Teste Atual / Recente',
        'orientation.live_section_description': 'O relatório inclui o histórico registrado durante a sessão atual do módulo.',
        'orientation.live_section_no_data': 'Sem dados recentes disponíveis.',
        'orientation.auto_report_note': 'Relatório automático gerado pelo FastChecker II - Módulo Fast Orientation.',
        'orientation.setup.frequency': 'Frequência (MHz)',
        'orientation.setup.start_angle': 'Ângulo Inicial (°)',
        'orientation.setup.end_angle': 'Ângulo Final (°)',
        'orientation.setup.step': 'Step (°)',
        'orientation.setup.selected_epc': 'EPC Selecionado',
        'orientation.setup.test_name': 'Nome do Teste',
        'orientation.table.test_name': 'Nome do Teste',
        'orientation.table.epc': 'EPC',
        'orientation.table.start_angle': 'Ângulo Inicial (°)',
        'orientation.table.end_angle': 'Ângulo Final (°)',
        'orientation.table.step': 'Step (°)',
        'orientation.table.frequency': 'Freq (MHz)',
        'orientation.table.angular_opening': 'Abertura (°)',
        'orientation.table.main_lobe': 'Direção Lobular (°)',
        'orientation.table.timestamp': 'Data/Hora',
        'orientation.table.points': 'Pontos',
        'orientation.measurement.angle': 'Ângulo (°)',
        'orientation.measurement.threshold': 'Threshold',
        'orientation.not_available': 'N/D',
        
        # Noise Module PDF
        'pdf.report_title_noise': 'Relatório de Testes - Noise Check',
        'pdf.test_description_title_noise': 'Descrição do Teste',
        'pdf.test_description_text_noise': 'Este relatório apresenta os resultados das medições de ruído ambiente coletadas pelo módulo Noise Check do FastChecker II. As análises destacam os níveis mínimo, médio e máximo de ruído ao longo do tempo para auxiliar na avaliação de ambientes RFID.',
        'pdf.test_summary_noise': 'Resumo dos Testes',
        'pdf.id_col': 'ID',
        'pdf.test_name_col': 'Nome',
        'pdf.duration_col': 'Duração (s)',
        'pdf.average_col': 'Médio (dBm)',
        'pdf.min_col': 'Mín (dBm)',
        'pdf.max_col': 'Máx (dBm)',
        'pdf.max_noise_time_col': 'Hora Ruído Máximo',
        'pdf.date_time_col': 'Data/Hora',
        'pdf.severity_col': 'Severidade',
        'pdf.noise_chart_title': 'Noise Check',
        
        # RSSI Power Module PDF
        'pdf.report_title_rssi': 'Relatório de Testes - RSSI x Power',
        'pdf.test_description_title_rssi': 'Descrição do Teste',
        'pdf.test_description_text_rssi': 'Este relatório contém os resultados dos testes de RSSI x Power realizados pelo FastChecker II. Os testes avaliam a relação entre a potência de transmissão e o nível de sinal recebido (RSSI) das tags RFID, fornecendo dados essenciais para otimização da comunicação e alcance do sistema RFID.',
        'pdf.test_configuration_rssi': 'Configuração do Teste',
        'pdf.parameter': 'Parâmetro',
        'pdf.value': 'Valor',
        'pdf.name': 'Nome',
        'pdf.tag_epc': 'EPC da Tag',
        'pdf.frequency': 'Frequência',
        'pdf.timestamp': 'Timestamp',
        'pdf.test_history': 'Histórico de Testes',
        'pdf.name_col': 'Nome',
        'pdf.tag_epc_col': 'EPC da Tag',
        'pdf.freq_mhz_col': 'Freq (MHz)',
        'pdf.power_range': 'Range Potência',
        'pdf.rssi_range': 'Range RSSI',
        'pdf.slope': 'Slope',
        'pdf.date_time_col': 'Data/Hora',
        'pdf.rssi_chart_title': 'RSSI x Power',
        'pdf.auto_report_footer': 'Relatório automático gerado pelo FastChecker',
        
        # Antenna Module PDF
        'pdf.report_title_antenna': 'Relatório de Testes - Antenna Check',
        'pdf.test_description_title_antenna': 'Descrição do Teste',
        'pdf.test_description_text_antenna': 'Este relatório contém os resultados dos testes de antena realizados pelo FastChecker II. Os testes avaliam o desempenho da antena RFID através da análise do Return Loss e VSWR em diferentes frequências, fornecendo informações essenciais para otimização do sistema de comunicação RFID.',
        'pdf.test_statistics': 'Estatísticas dos Testes',
        'pdf.total_tests': 'Total de Testes:',
        'pdf.total_data_points': 'Total de Pontos de Dados:',
        'pdf.freq_range_general': 'Faixa de Frequência Geral:',
        'pdf.avg_power': 'Potência Média:',
        'pdf.min_power': 'Potência Mínima:',
        'pdf.max_power': 'Potência Máxima:',
        'pdf.test_history_antenna': 'Histórico de Testes',
        'pdf.name_col_antenna': 'Nome',
        'pdf.power_db': 'Pot (dBm)',
        'pdf.freq_range': 'Range Freq (MHz)',
        'pdf.min_return_loss': 'Min Return Loss (dBm)',
        'pdf.vswr': 'VSWR',
        'pdf.freq_at_best': 'Na Freq (MHz)',
        'pdf.charts_title_antenna': 'Gráficos dos Testes',
        'pdf.antenna_chart_title': 'Antenna Check',
        'pdf.test_id': 'Teste ID:',
        'pdf.freq_range_detail': 'Faixa:',
        'pdf.points': 'Pontos:',
        'pdf.rl_min': 'RL Min:',
        'pdf.rl_max': 'RL Max:',
        'pdf.rl_avg': 'RL Médio:',
        
        # Population Module PDF
        'pdf.population_test_data': 'Dados dos Testes',
        'pdf.population_epc_col': 'EPC',
        'pdf.population_nickname_col': 'Apelido',
        'pdf.population_comment_col': 'Comentário',
        'pdf.population_coords_col': 'Coordenadas',
        'pdf.population_power_col': 'Potência (dBm)',
        'pdf.population_rssi_col': 'RSSI (dBm)',
        'pdf.population_margin_col': 'Margem (dBm)',
        'pdf.population_freq_col': 'Frequência',
        'pdf.population_datetime_col': 'Data / Hora',
        'pdf.population_summary_num_tested': 'Número de tags testadas',
        'pdf.population_summary_num_read': 'Número de tags lidas',
        'pdf.population_summary_num_not_read': 'Número de tags não lidas',
        'pdf.population_summary_avg_margin': 'Margem média de leitura (dBm)',
        'pdf.population_summary_min_margin': 'Menor margem de leitura (dBm)',
        'pdf.population_no_tag_detected': 'Nenhuma tag detectada',
        'pdf.population_not_read': '(NAO LIDA)',
        
        'threshold.error_freq_min_greater_max': 'Frequência mínima ({min} MHz) deve ser menor que a máxima ({max} MHz).\n\nPor favor, insira valores válidos.',
        'threshold.error_max_power_above': 'Potência máxima {power} dBm está acima do limite da licença ativa.\n\nLicença permite até: {max_allowed} dBm\nPor favor, insira um valor até {max_allowed} dBm.',
        'threshold.error_max_power_below': 'Potência máxima {power} dBm está abaixo do limite da licença ativa.\n\nLicença permite: {min_allowed} a {max_allowed} dBm\nPor favor, insira um valor entre {min_allowed} e {max_allowed} dBm.',
        'threshold.error_description_required': 'Descrição Obrigatória',
        'threshold.error_description_required_msg': 'É obrigatório fornecer uma descrição para o teste.\n\nA descrição é necessária para:\n• Identificar o teste no histórico\n• Legendar corretamente os gráficos\n• Organizar e comparar resultados',
        'threshold.error_description_duplicate': 'Descrição Duplicada',
        'threshold.error_description_duplicate_msg': 'A descrição "{description}" já foi usada anteriormente.\n\nJá existe um teste com esta descrição no histórico.\nPor favor, escolha uma descrição diferente.',
        'threshold.info_no_test_to_cancel': 'Informação',
        'threshold.info_no_test_to_cancel_msg': 'Nenhum teste está em execução para cancelar.',
        'threshold.info_test_cancelled': 'Teste Cancelado',
        
        # Population Module
        'population.select_an_action': 'Selecionar uma ação',
        'population.browser_mode': 'modo browser',
        'population.tags_registered': 'tags registradas',
        'population.tags_selected': 'tags selecionadas',
        'population.register_new_tags': '+ Registrar Novas Tags',
        'population.import_tag_json': '+ Importar Tag de arquivo JSON',
        'population.select_all_tags': '+ Selecionar Todas as Tags',
        'population.deselect_all_tags': '+ Desselecionar Todas as Tags',
        'population.erase_selected_tags': '- Excluir Tags Selecionadas',
        'population.save_selected_tags': '> Salvar Tags Selecionadas (JSON)',
        'population.registered_tags': 'Tags Registradas',
        'population.tag_epc': 'Tag EPC',
        'population.test_management': 'Gerenciamento de Testes',
        'population.save_test': 'Salvar Teste',
        'population.import_test': 'Importar Teste',
        'population.clear_test': 'Limpar Teste',
        'population.test_config': 'Configuração do Teste',
        'population.frequency_mhz': 'Frequência (MHz):',
        'population.power_max_dbm': 'Potência Max (dBm):',
        'population.distance_m': 'Distância (m):',
        'population.power_step_db': 'Step de Potência (dB):',
        'population.description': 'Descrição:',
        'population.start_test': 'Start Test',
        'population.stop': 'Stop',
        'population.pdf_report': 'Relatório PDF',
        'population.graph_title': 'Population de Tags RFID - Tempo Real',
        'population.graph_xlabel': 'Potência (dBm)',
        'population.graph_ylabel': 'Número de Tags Selecionadas Detectadas',
        'population.progress_label': 'Progresso da Potência',
        'population.tags_detected': 'Tags Detectadas',
        'population.tag': 'Tag',
        'population.position': 'Posição',
        'population.power': 'Potência',
        'population.count': 'Count',
        'population.status': 'Status',
        'population.date_time': 'Data/Hora',
        'population.graph_column': 'Graph',
        'population.table_column_epc': 'EPC',
        'population.table_column_nickname': 'Apelido',
        'population.table_column_comment': 'Comentario',
        'population.table_column_coordinates': 'Coordenadas',
        'population.table_column_power': 'Potencia (dBm)',
        'population.table_column_rssi': 'RSSI (dBm)',
        'population.table_column_margin': 'Margem (dBm)',
        'population.table_column_frequency': 'Frequencia',
        'population.table_column_datetime': 'Data / Hora',
        'population.test_name_column': 'Nome do Teste',
        'population.test_name_placeholder': 'Teste de Population',
        'population.no_results': 'Sem Resultados',
        'population.no_results_msg': 'O teste selecionado não possui resultados para mostrar.',
        'population.matplotlib_unavailable': 'Matplotlib não disponível',
        'population.graph_3d_title': 'Posicionamento 3D das Tags',
        'population.graph_3d_error': 'Matplotlib não disponível\npara gráfico 3D',
        'population.graph_3d_config_error': 'Erro ao configurar\nGráfico 3D:',
        'population.test_data_title': 'Dados do Teste',
        'population.edit_tag': 'Editar Tag',
        'population.nickname_label': 'Apelido:',
        'population.coordinates_label': 'Coordenadas (X,Y,Z):',
        'population.power_tooltip': 'Potência: {power} dBm',
        'population.epc_tooltip': 'EPC: {epc}',
        'population.epcs_tooltip': 'EPCs ({count} tags):',
        'population.report_title': 'Relatório de Population',
        'population.system_info': 'Informações do Sistema',
        'population.test_config_title': 'Configuração do Teste',
        'population.test_results_summary': 'Resumo dos Resultados',
        'population.parameter': 'Parâmetro',
        'population.value': 'Valor',
        'population.save_test_data': 'Salvar Dados do Teste',
        'population.save_complete_report': 'Salvar Relatório Completo',
        'population.import_complete_report': 'Importar Relatório Completo',
        'population.select_json_file': 'Selecionar Arquivo JSON para Importação',
        'population.save_selected_tags': 'Salvar Tags Selecionadas',
        'population.save_pdf_report': 'Salvar Relatório PDF',
        'population.risk_image': 'Imagem de Risco',
        'population.error_counting_tags': 'Erro ao contar tags',
        'population.error_counting_selection': 'Erro ao contar seleção',
        'population.software_label': 'Software:',
        'population.hardware_label': 'Hardware:',
        'population.firmware_label': 'Firmware:',
        'population.serial_number_label': 'Número de Série:',
        'population.license_label': 'Licença:',
        'population.generated_at_label': 'Gerado em:',
        'population.error_description_required': 'Descrição Obrigatória',
        'population.error_description_required_msg': 'É obrigatório informar uma descrição para o teste.\n\nA descrição é necessária para:\n• Identificar o teste no histórico\n• Rotular corretamente os gráficos\n• Organizar e comparar resultados',
        'population.error_freq_blocked': 'Frequencia bloqueada pela licença',
        'population.error_validation': 'Erro de Validação',
        'population.error_power_invalid': 'Potência deve ser um número válido.',
        'population.warning_test_in_progress': 'Teste em Andamento',
        'population.warning_test_in_progress_msg': 'Um teste já está em execução.',
        'population.error_safety_stop': 'Parada de Segurança',
        'population.error_reflected_power_high': 'Potência Refletida Alta',
        'population.error_power_range': 'Potência deve estar entre {min_power} e {max_power} dBm.\n\nValor inserido: {value} dBm',
        'population.error_invalid_parameters': 'Parâmetros inválidos. Verifique os valores inseridos.',
        'population.warning_browser_mode': 'Modo Browser',
        'population.warning_browser_mode_msg': 'Função de teste indisponível sem licença ativa.',
        'population.warning_no_tags_selected': 'Aviso',
        'population.warning_no_tags_selected_msg': 'Nenhuma tag selecionada para o teste.',
        'population.error_nickname_max_length': 'O apelido deve ter no máximo 4 caracteres.',
        'population.error_nickname_invalid_chars': 'O apelido contém caracteres não permitidos. Use apenas letras, números, espaços e caracteres especiais comuns (# & % @ - _ . , ! ? ( )).',
        'population.error_coordinates_format': 'As coordenadas devem estar no formato X,Y,Z (exemplo: 1,2,3)',
        'population.error_coordinates_numeric': 'As coordenadas devem conter apenas números (exemplo: 1,2,3)',
        'population.warning_duplicate_nickname': 'Apelido Duplicado',
        'population.warning_duplicate_nickname_msg': 'O apelido \'{nickname}\' já está registrado para outra tag.\n\nPor favor, escolha um apelido diferente.',
        'population.warning_duplicate_coordinates': 'Coordenadas Duplicadas',
        'population.warning_duplicate_coordinates_msg': 'As coordenadas \'{coordinates}\' já estão registradas para outra tag.\n\nPor favor, escolha coordenadas diferentes.',
        'population.success_tag_saved': 'Informações da tag {epc}... salvas com sucesso!',
        'population.error_saving_tag': 'Erro ao salvar informações: {error}',
        'population.warning_no_data_export': 'Sem Dados',
        'population.warning_no_data_export_msg': 'Nenhum dado de teste disponível para exportar.',
        'population.success_exported': 'Dados exportados com sucesso para:\n{filename}',
        'population.error_export_failed': 'Falha ao exportar dados:\n{error}',
        'population.error_report_generation_failed': 'Falha ao gerar relatório:\n{error}',
        'population.error_save_file_failed': 'Falha ao salvar arquivo:\n{error}',
        'population.success_report_saved': 'Relatório PDF gerado com sucesso!\n\nArquivo: {filepath}',
        'population.error_save_test_failed': 'Falha ao salvar teste:\n{error}',
        'population.success_test_imported': 'Relatório \'{test_name}\' importado com sucesso!',
        'population.error_import_failed': 'Falha ao importar relatório:\n{error}',
        'population.success_test_cleared': 'Teste limpo com sucesso!\n\nTodos os dados foram removidos.',
        'population.error_clear_failed': 'Falha ao limpar teste:\n{error}',
        'population.error_hardware_not_detected': 'Hardware não detectado.',
        'population.error_register_tags_failed': 'Falha ao registrar tags: {error}',
        'population.error_invalid_json': 'Formato de arquivo JSON inválido. Esperado lista de tags ou objeto com propriedade \'tags\'.',
        'population.error_reading_file': 'Erro de Leitura',
        'population.error_reading_file_msg': 'Não foi possível ler o arquivo:\n{error}',
        'population.warning_no_data_report': 'Nenhum dado de teste disponível para gerar relatório.',
        'population.error_generate_pdf_failed': 'Erro ao gerar relatório PDF:\n{error}',
        'population.warning_risk_image_not_found': 'Aviso',
        'population.warning_risk_image_not_found_msg': 'Imagem de Risco não encontrada.',
        'population.error_display_risk_image': 'Erro ao exibir imagem de Risco:\n{error}',
        'population.success': 'Sucesso',
        'population.error': 'Erro',
        'population.error_safety_stop_temp': 'Temperatura ({temp}°C) excedeu o limite de {limit}°C.\n\nO teste não pode ser iniciado por segurança do hardware.',
        'population.error_reflected_power_msg': 'Potência Refletida ({power} dBm) excedeu o limite de {limit} dBm.\n\nVerifique o sistema irradiante (antena).\nO teste não pode ser iniciado por segurança do hardware.',
        'population.error_reflected_power_during_test': 'Potência Refletida ({power} dBm) excedeu o limite de {limit} dBm.\n\nVerifique o sistema irradiante (antena).\nO teste foi interrompido por segurança do hardware.',
        'population.success_test_saved': 'Teste salvo com sucesso!\n\nArquivo: {filename}\n\nDados incluídos:\n• {points} pontos de teste\n• {tags} tags selecionadas\n• Configurações de hardware\n• Estado do gráfico\n• Parâmetros de teste',
        'population.confirm_clear': 'Confirmar Limpeza',
        'population.confirm_clear_msg': 'Tem certeza que deseja limpar todos os dados do teste atual?\n\nIsso irá remover:\n• Todos os pontos de teste\n• Dados da tabela\n• Gráfico atual\n• Tags detectadas\n\n⚠️ As tags selecionadas na lista \'Registered Tags\' serão mantidas',
        
        # Simulator Module
        'simulator.test_config': 'Configuração do Teste',
        'simulator.irradiated_power': 'Pot Irradiada (dBm):',
        'simulator.sensitivity': 'Sensibilidade (dBm):',
        'simulator.margin': 'Margem (dB):',
        'simulator.reports': 'Relatórios',
        'simulator.save': '💾 Salvar',
        'simulator.import': '📁 Importar',
        'simulator.slot': 'Slot',
        'simulator.import_data': 'Importar',
        'simulator.clear': 'Limpar',
        'simulator.risk': 'RISCO',
        'simulator.browser_mode': 'modo browser',
        'simulator.missing_params_title': 'Parâmetros Faltando',
        'simulator.missing_params_msg1': 'Não foi possível encontrar os parâmetros no arquivo.',
        'simulator.missing_params_msg2': 'Por favor, insira os valores usados no teste:',
        'simulator.distance': 'Distância (m):',
        'simulator.attenuator': 'Atenuador (dB):',
        'simulator.ok': 'OK',
        'simulator.cancel': 'Cancelar',
        'simulator.select_test_title': 'Selecione um Teste do Projeto',
        'simulator.select_test_msg': 'O arquivo de projeto contém múltiplos testes. Por favor, selecione um para carregar:',
        'simulator.id': 'ID',
        'simulator.description': 'Descrição',
        'simulator.tag_epc': 'EPC da Tag',
        'simulator.date': 'Data',
        'simulator.load_selected': 'Carregar Teste Selecionado',
        'simulator.import_test_for_slot': 'Importar Teste para Slot',
        'simulator.select_project': 'Selecionar Projeto',
        'simulator.project': 'Projeto:',
        'simulator.test_history': 'Histórico de Testes',
        'simulator.epc': 'EPC',
        'simulator.date_time': 'Data/Hora',
        'simulator.type': 'Tipo',
        'simulator.test_info': 'Informações do Teste',
        'simulator.import_button': 'Importar',
        'simulator.risk_image_enlarged': 'Imagem de Risco Ampliada',
        'simulator.close': 'Fechar',
        'simulator.image_not_found': 'Arquivo \'Risco.png\' não encontrado.\nProcurado em:',
        'simulator.image_load_error': 'Erro ao carregar imagem:',
        'simulator.validation_error': 'Erro de Validação',
        'simulator.validation_error_msg': 'Por favor, insira valores numéricos válidos.',
        'simulator.invalid_test': 'Teste Inválido',
        'simulator.invalid_test_msg': 'O teste selecionado (\'{desc}\') não contém dados de medição (\'results\') e não pode ser simulado.\n\nPor favor, escolha outro teste da lista.',
        'simulator.test_info_desc': 'Descrição:',
        'simulator.test_info_epc': 'EPC:',
        'simulator.test_info_date': 'Data:',
        'simulator.test_info_attenuator': 'Atenuador:',
        'simulator.test_info_distance': 'Distância:',
        'simulator.test_info_duration': 'Duração:',
        'simulator.invalid_value': 'Valor Inválido',
        'simulator.invalid_value_msg': 'A margem deve ser um número positivo ou zero.\n\nValores negativos não são permitidos.',
        'simulator.save_error': 'Erro ao Salvar',
        'simulator.save_error_msg': 'Erro ao salvar relatório:\n{error}',
        'simulator.invalid_format': 'Formato Inválido',
        'simulator.invalid_format_msg': 'O arquivo selecionado não é um relatório de simulação válido.',
        'simulator.import_report_title': 'Importar Relatório de Simulação',
        'simulator.save_report_title': 'Salvar Relatório de Simulação',
        'simulator.graph_performance': 'Performance',
        'simulator.graph_frequency': 'Frequência (MHz)',
        'simulator.graph_distance': 'Distância (m)',
        'simulator.graph_forward_link': 'Forward Link (Threshold)',
        'simulator.graph_reverse_link': 'Reverse Link (Threshold)',
        'simulator.graph_link_final': 'Link Final (Threshold)',
        'simulator.graph_link_final_margin': 'Link Final (Margem {margin} dB)',
        'simulator.graph_import_file': 'Importe um arquivo .json',
        'simulator.error_irradiated_power_limit': 'Erro - Limite de Potência Irradiada',
        'simulator.error_irradiated_power_limit_anatel': 'A potência irradiada máxima permitida para licenças Anatel ou faixas de 800 a 1000 MHz é de {max_power} dBm.\n\nValor inserido: {value} dBm\nLimite máximo: {max_power} dBm\n\nPor favor, ajuste o valor para {max_power} dBm ou menos.',
        'simulator.error_irradiated_power_limit_etsi': 'A potência irradiada máxima permitida para licenças ETSI é de {max_power} dBm.\n\nValor inserido: {value} dBm\nLimite máximo: {max_power} dBm\n\nPor favor, ajuste o valor para {max_power} dBm ou menos.',
        'simulator.success_data_loaded': 'Sucesso',
        'simulator.success_data_loaded_msg': 'Dados carregados com sucesso no Slot #{slot}.',
        'simulator.error_import_failed': 'Erro de Importação',
        'simulator.error_import_failed_msg': 'Não foi possível processar o arquivo:\n{error}\n\n{traceback}',
        'simulator.error_invalid_project': 'Erro',
        'simulator.error_invalid_project_msg': 'O arquivo selecionado não é um projeto válido do Threshold.',
        'simulator.error_load_project': 'Erro',
        'simulator.error_load_project_msg': 'Erro ao carregar o arquivo de projeto:\n{error}',
        'simulator.error_read_file': 'Erro',
        'simulator.error_read_file_msg': 'Erro ao ler arquivo: {error}',
        'simulator.error_missing_libraries': 'Bibliotecas Faltando',
        'simulator.error_missing_libraries_msg': 'Este programa requer as bibliotecas Matplotlib, Pandas e Pillow.\n\nPor favor, instale-as abrindo o terminal ou prompt de comando e digitando:\npip install matplotlib pandas pillow',
        'simulator.select_threshold_project': 'Selecionar Arquivo de Projeto do Threshold',
        'simulator.select_project_file': 'Selecionar Arquivo de Projeto',
        
        # Noise Check Module - Error Messages
        'noise.test_name_required': 'Nome do Teste Obrigatório',
        'noise.test_name_required_msg': 'Por favor, digite um nome para o teste antes de iniciar.\n\nO nome do teste é obrigatório e deve ser único no histórico.',
        'noise.test_name_duplicate': 'Nome Duplicado',
        'noise.test_name_duplicate_msg': 'Já existe um teste com o nome \'{name}\' no histórico.\n\nPor favor, escolha um nome diferente para este teste.',
        'noise.mode_required': 'Modo de Operação Obrigatório',
        'noise.mode_required_msg': 'Por favor, selecione um modo de operação:\n\n• Único: Teste com duração definida\n• Contínuo: Teste contínuo até parar manualmente',
        'noise.duration_required': 'Tempo de Duração Obrigatório',
        'noise.duration_required_msg': 'No modo Único, o tempo de duração é obrigatório.\n\nPor favor, digite o tempo de duração do teste.\nExemplo: 60 (para 60 segundos)',
        'noise.duration_invalid': 'Tempo Inválido',
        'noise.duration_invalid_msg': 'O tempo \'{duration}\' não é válido.\n\nPor favor, digite um número maior que zero.\nExemplo: 60 (para 60 segundos)',
        'noise.success': 'Sucesso',
        'noise.success_report_generated': 'Relatório PDF dos testes selecionados gerado com sucesso!\n\nArquivo: {filepath}\n\nTestes incluídos: {count}',
        'noise.demo_mode': 'Modo Demo',
        'noise.demo_mode_msg': 'Este módulo está funcionando em modo demo.\n\nPara funcionalidade completa, adicione uma licença válida no módulo License.',
        'noise.invalid_license': 'Licença Inválida',
        'noise.invalid_license_msg': 'Funcionalidade desabilitada.',
        'noise.invalid_license_not_found': 'Nenhuma licença ativa encontrada.\n\nPara usar este módulo, ative uma licença válida no módulo License.',
        'noise.freq_outside_license': 'Frequência fora da faixa da licença',
        'noise.freq_outside_license_msg': 'A frequência de operação do Noise Check ({freq} MHz) está fora da faixa permitida pela licença.\n\nFaixa permitida: {min_freq} - {max_freq} MHz\nFrequência do módulo: {freq} MHz\n\nEste módulo não pode operar com a licença atual.',
        'noise.safety_stop_temp': 'Parada de Segurança',
        'noise.safety_stop_temp_msg': 'Temperatura ({temp}°C) excedeu o limite de {limit}°C.',
        'noise.reflected_power_high': 'Potência Refletida Alta',
        'noise.reflected_power_high_msg': 'Potência Refletida ({power:.1f} dBm) excedeu o limite de {limit} dBm.\n\nVerifique o sistema irradiante (antena).\nO teste não pode ser iniciado por segurança do hardware.',
        'noise.no_test_selected_save': 'Nenhum Teste Selecionado',
        'noise.no_test_selected_save_msg': 'Por favor, selecione um ou mais testes no histórico para salvar.',
        'noise.save_tests_title': 'Salvar Testes Selecionados',
        'noise.tests_saved_success': '{count} teste(s) salvos com sucesso em:\n{filename}',
        'noise.error_saving_tests': 'Erro ao Salvar',
        'noise.error_saving_tests_msg': 'Não foi possível salvar os testes.\nErro: {error}',
        'noise.import_tests_title': 'Importar Testes para o Histórico',
        'noise.no_tests_in_file': 'Nenhum Teste Encontrado',
        'noise.no_tests_in_file_msg': 'O arquivo selecionado não contém dados de teste no formato esperado.',
        'noise.import_error': 'Erro de Importação',
        'noise.import_error_msg': 'Não foi possível ler o arquivo.\nErro: {error}',
        'noise.db_unavailable_report': 'Aviso',
        'noise.db_unavailable_report_msg': 'Banco de dados não disponível para gerar relatório.',
        'noise.no_test_selected_report': 'Nenhum Teste Selecionado',
        'noise.no_test_selected_report_msg': 'Por favor, selecione um ou mais testes no histórico para gerar o relatório.',
        'noise.no_valid_test': 'Aviso',
        'noise.no_valid_test_msg': 'Nenhum teste válido encontrado entre os selecionados.',
        'noise.pdf_module_not_found': 'Erro',
        'noise.pdf_module_not_found_msg': 'Módulo de geração de PDF não encontrado.\nErro: {error}',
        'noise.error_generating_pdf': 'Erro ao gerar relatório PDF:\n{error}',
        'noise.error_unexpected_pdf': 'Erro inesperado ao gerar relatório:\n{error}',
        'noise.no_test_selected_delete': 'Nenhum Teste Selecionado',
        'noise.no_test_selected_delete_msg': 'Por favor, selecione um ou mais testes no histórico para excluir.',
        'noise.tests_deleted': 'Operação Concluída',
        'noise.tests_deleted_msg': '{count} teste(s) foram excluídos com sucesso.',
        'noise.error_loading_history': 'Erro',
        'noise.error_loading_history_msg': 'Erro ao carregar histórico: {error}',
        'noise.name_duplicate_inline': 'Nome Duplicado',
        'noise.name_duplicate_inline_msg': 'Já existe um teste com o nome \'{name}\' no histórico.\n\nPor favor, escolha um nome diferente.',
        
        # Antenna Check Module - Error Messages
        'antenna.reset_warning': 'Aviso de Reset',
        'antenna.reset_warning_msg': 'Não foi possível executar o Soft Reset do hardware.\n\nO teste continuará, mas pode haver problemas se o hardware estiver em estado inconsistente.\n\nSe o problema persistir, desplugue e reconecte o cabo USB do leitor.',
        'antenna.safety_stop': 'Parada de Segurança',
        'antenna.safety_stop_temp_msg': 'Temperatura ({temp}°C) excedeu o limite de {limit}°C.\n\nO teste não pode ser iniciado por segurança do hardware.',
        'antenna.reflected_power_high': 'Potência Refletida Alta',
        'antenna.reflected_power_high_msg': 'Potência Refletida ({power} dBm) excedeu o limite de {limit} dBm.\n\nVerifique o sistema irradiante (antena).\nO teste não pode ser iniciado por segurança do hardware.',
        'antenna.invalid_license': 'Licença Inválida',
        'antenna.test_disabled': 'A funcionalidade de teste está desabilitada.',
        'antenna.name_empty': 'Nome Vazio',
        'antenna.name_empty_msg': 'O campo \'Nome\' não pode estar vazio.',
        'antenna.name_duplicate': 'Nome Duplicado',
        'antenna.name_duplicate_msg': 'Já existe um teste com o nome \'{name}\' no histórico.\n\nPor favor, escolha um nome diferente para este teste.',
        'antenna.freq_outside_ranges': 'Frequência fora das faixas da licença',
        'antenna.freq_outside_ranges_msg': 'A frequência selecionada ({freq_min}-{freq_max} MHz) está fora das faixas permitidas pela licença.\n\nFaixas permitidas: {ranges}\nFrequência selecionada: {freq_min} - {freq_max} MHz\n\nAjuste a frequência para dentro de uma das faixas permitidas.',
        'antenna.freq_outside_range': 'Frequência fora da faixa da licença',
        'antenna.freq_outside_range_msg': 'A frequência selecionada ({freq_min}-{freq_max} MHz) está fora da faixa permitida pela licença.\n\nFaixa permitida: {min_freq} - {max_freq} MHz\nFrequência selecionada: {freq_min} - {freq_max} MHz\n\nAjuste a frequência para dentro da faixa permitida.',
        'antenna.power_outside_range': 'Potência fora da faixa da licença',
        'antenna.power_outside_range_msg': 'A potência selecionada ({power} dBm) está fora da faixa permitida pela licença.\n\nFaixa permitida: {min_power} - {max_power} dBm\nPotência selecionada: {power} dBm\n\nAjuste a potência para dentro da faixa permitida.',
        'antenna.validation_error': 'Erro de Validação',
        'antenna.invalid_freq_values': 'Valores de frequência inválidos.',
        'antenna.invalid_power_value': 'Valor de potência inválido.',
        'antenna.communication_error': 'Erro de Comunicação',
        'antenna.communication_error_msg': 'Falha ao abrir a porta COM{port}. Verifique a conexão do hardware.',
        'antenna.protection_activated': 'Proteção Ativada',
        'antenna.protection_activated_msg': 'Teste interrompido. Return Loss muito alto: {power} dBm.',
        'antenna.scan_error': 'Erro de Scan',
        'antenna.scan_error_msg': 'Ocorreu um erro durante a varredura: {error}',
        'antenna.no_tests': 'Nenhum Teste',
        'antenna.no_tests_msg': 'Arquivo não contém dados de teste válidos.',
        'antenna.success': 'Sucesso',
        'antenna.tests_imported': '{count} teste(s) importado(s).',
        'antenna.tests_saved': '{count} teste(s) salvos em:\n{filename}',
        'antenna.error': 'Erro',
        'antenna.import_failed': 'Falha ao importar.\n{error}',
        'antenna.save_failed': 'Falha ao salvar testes.\n{error}',
        'antenna.database_unavailable': 'Banco de dados não disponível.',
        'antenna.nothing_selected': 'Nada Selecionado',
        'antenna.select_to_save': 'Selecione testes no histórico para salvar.',
        'antenna.select_to_delete': 'Selecione testes no histórico para excluir.',
        'antenna.empty_file': 'Arquivo Vazio',
        'antenna.no_tests_in_file': 'Nenhum teste encontrado no arquivo.',
        'antenna.invalid_file_structure': 'Arquivo inválido: estrutura \'tests\' não encontrada.',
        'antenna.invalid_json': 'Arquivo JSON inválido.',
        'antenna.import_failed_error': 'Falha ao importar testes.\n{error}',
        'antenna.confirm_import': 'Confirmar Importação',
        'antenna.confirm_import_msg': 'Importar {count} teste(s) de antena?\n\nArquivo: {filename}',
        'antenna.tests_imported_success': '{count} teste(s) importado(s) com sucesso.',
        'antenna.tests_deleted': '{count} teste(s) excluídos.',
        'antenna.save_tests_dialog': 'Salvar Testes de Antena',
        'antenna.import_tests_dialog': 'Importar Testes de Antena',
        'antenna.import_tests_title': 'Importar Testes de Antena',
        'antenna.success_report_generated': 'Relatório PDF dos testes selecionados gerado com sucesso!\n\nArquivo: {filepath}\n\nTestes incluídos: {count}',
        'antenna.demo_mode': 'Modo Demo',
        'antenna.demo_mode_msg': 'Este módulo está funcionando em modo demo.',
        'antenna.db_unavailable_report': 'Aviso',
        'antenna.db_unavailable_report_msg': 'Banco de dados não disponível para gerar relatório.',
        'antenna.no_test_selected_report': 'Nenhum Teste Selecionado',
        'antenna.no_test_selected_report_msg': 'Por favor, selecione um ou mais testes no histórico para gerar o relatório.',
        'antenna.no_valid_test': 'Aviso',
        'antenna.no_valid_test_msg': 'Nenhum teste válido encontrado entre os selecionados.',
        'antenna.error_generating_pdf': 'Erro',
        'antenna.error_generating_pdf_msg': 'Erro ao gerar relatório PDF:\n{error}',
        'antenna.error_unexpected_pdf': 'Erro ao gerar relatório PDF:\n{error}',
        
        # RSSI x Power Module - Validation Messages
        'rssi_power.test_name_required': 'Nome do Teste Obrigatório',
        'rssi_power.test_name_required_msg': 'Por favor, digite um nome para o teste antes de iniciar.\n\nO nome do teste é obrigatório.',
        'rssi_power.freq_outside_license': 'Frequência fora das faixas da licença',
        'rssi_power.freq_outside_msg': 'A frequência selecionada ({freq} MHz) está fora das faixas permitidas pela licença.\n\nFaixas permitidas: {allowed}\nFaixas excluídas: {excluded}\nFrequência selecionada: {freq} MHz\n\nAjuste a frequência para dentro de uma das faixas permitidas.',
        'rssi_power.freq_outside_scan_msg': 'A frequência selecionada ({freq} MHz) está fora das faixas permitidas pela licença.\n\nFaixas permitidas: {allowed}\nFaixas excluídas: {excluded}\nFrequência selecionada: {freq} MHz\n\nAjuste a frequência para dentro de uma das faixas permitidas antes de fazer o scan.',
        'rssi_power.test_running_scan_msg': 'Pare o teste atual antes de buscar novas tags.',
        'rssi_power.invalid_license': 'Licença Inválida',
        'rssi_power.invalid_license_msg': 'Nenhuma licença ativa encontrada.\n\nPara usar este módulo, ative uma licença válida no módulo License.',
        'rssi_power.demo_mode': 'Modo Demo',
        'rssi_power.demo_mode_msg': 'Este módulo está funcionando em modo demo.',
        'rssi_power.dll_error': 'Erro de DLL',
        'rssi_power.dll_error_msg': 'O arquivo \'{dll}\' não foi encontrado.',
        'rssi_power.no_tag': 'Nenhuma Tag',
        'rssi_power.no_tag_msg': 'Por favor, selecione uma tag para testar.',
        'rssi_power.name_duplicate': 'Nome Duplicado',
        'rssi_power.name_duplicate_msg': 'Já existe um teste com o nome \'{name}\' no histórico.\n\nPor favor, escolha um nome diferente para este teste.',
        'rssi_power.test_running': 'Teste em Andamento',
        'rssi_power.test_running_msg': 'Já há um teste em execução.',
        'rssi_power.browser_warning': 'Modo Browser',
        'rssi_power.browser_warning_msg': 'Função de teste indisponível sem licença ativa.',
        'rssi_power.safety_stop': 'Parada de Segurança',
        'rssi_power.safety_stop_msg': 'Temperatura ({temp}°C) excedeu o limite de {limit}°C.\n\nO teste não pode ser iniciado por segurança do hardware.',
        'rssi_power.hardware_error': 'Erro de Hardware',
        'rssi_power.hardware_error_msg': 'Não foi possível conectar à porta COM{port}',
        'rssi_power.tag_search': 'Busca de Tags',
        'rssi_power.no_tags_found': 'Nenhuma tag encontrada no ambiente.',
        # App Shell - Language Selector
        'app.language': 'Idioma',
        'app.language_portuguese': 'Português',
        'app.language_english': 'English',
    },
    'en': {
        # App Shell
        'app_shell.error_missing_library': 'Missing Library',
        'app_shell.error_missing_library_msg': 'The \'Pillow\' library is required. Install with: pip install Pillow',
        'app_shell.error_hardware_not_found': 'Hardware Error',
        'app_shell.error_hardware_not_found_msg': 'Hardware \'Silicon Labs CP210x\' not found. Check the connection and drivers.',
        'app_shell.warning_hardware_reset': 'Hardware Warning',
        'app_shell.warning_hardware_reset_msg': 'Initial reset command failed. The connection may be unstable.',
        'app_shell.warning_test_in_progress': 'Test in Progress',
        'app_shell.warning_test_in_progress_msg': 'Wait for the test to finish.',
        'app_shell.error_module_load': 'Error',
        'app_shell.error_module_load_msg': 'Error loading module {module}:\n{error}',
        'app_shell.error_module_debug': 'Module Error (Debug)',
        'app_shell.error_module_debug_msg': 'An error occurred while trying to load module \'{module}\'.\n\nFull traceback:\n\n{traceback}',
        
        # Rename Popup
        'rename.title': 'Rename Tag',
        'rename.epc': 'EPC:',
        'rename.tag_name': 'Tag Name:',
        'rename.save': 'Save',
        'rename.cancel': 'Cancel',
        'rename.error_empty_title': 'Input Error',
        'rename.error_empty_msg': 'Tag name cannot be empty.',
        'rename.error_max_length_title': 'Input Error',
        'rename.error_max_length_msg': 'Nickname must be at most 4 characters.',
        'rename.error_database_title': 'Database Error',
        'rename.error_database_msg': 'Could not update the tag name.',
        
        # License Module
        'license.system_information': 'System Information',
        'license.software': 'Software:',
        'license.hardware': 'Hardware:',
        'license.firmware': 'Firmware:',
        'license.status_default': 'License system',
        'license.status_connecting': 'Connecting...',
        'license.status_browser_mode': 'Browser Mode - limited functionality',
        'license.reload_button': 'Reload System Information',
        'license.license_information': 'License Information',
        'license.auto_license': 'Auto License',
        'license.import_license': 'Import License',
        'license.eula_agreement': 'License Agreement',
        'license.licenses_on_device': 'Licenses on Device',
        'license.active': 'Active',
        'license.inactive': 'Inactive',
        'license.select': 'Select',
        'license.device_licenced': 'Device Licensed',
        'license.device_not_licenced': 'Device Not Licensed - Browser Mode',
        'license.device_connected': 'Device Connected - Browser Mode',
        
        # RSSI x Power Module
        'rssi_power.browser_mode': 'browser mode',
        'rssi_power.test_config': 'Test Configuration',
        'rssi_power.name': 'Name:',
        'rssi_power.frequency_mhz': 'Frequency (MHz):',
        'rssi_power.samples_per_point': 'Samples per Point:',
        'rssi_power.power_step_dbm': 'Power Step (dBm):',
        'rssi_power.tag_selection': 'Tag Selection',
        'rssi_power.register_tag': '🔍 Tag Registration',
        'rssi_power.no_tag_selected': 'No tag selected',
        'rssi_power.tag_selected': 'Selected:',
        'rssi_power.controls': 'Controls',
        'rssi_power.test': 'Test',
        'rssi_power.stop': 'Stop',
        'rssi_power.clear_plot': 'Clear Plot',
        'rssi_power.save_selected': 'Save Selected',
        'rssi_power.import_tests': 'Import Tests',
        'rssi_power.generate_report': 'Selected Report (PDF)',
        'rssi_power.graph_title': 'RSSI vs Power',
        'rssi_power.test_history': 'Test History',
        'rssi_power.stats_loading': 'Statistics: Loading...',
        'rssi_power.plot': 'Plot',
        'rssi_power.name_col': 'Name',
        'rssi_power.tag_epc': 'Tag EPC',
        'rssi_power.frequency_col': 'Freq (MHz)',
        'rssi_power.power_range': 'Power (dBm)',
        'rssi_power.rssi_range': 'RSSI (dBm)',
        'rssi_power.slope': 'Slope (dBm/dBm)',
        'rssi_power.date_time': 'Date/Time',
        'rssi_power.select_all': 'Select All',
        'rssi_power.stats_format': 'Statistics: {count} tests | {tags} unique tags{slope}',
        'rssi_power.stats_format_single': 'Statistics: {count} test | {tags} unique tag{slope}',
        'rssi_power.slope_stats': ' | Slope: {avg:.3f} (min: {min:.3f}, max: {max:.3f})',
        'rssi_power.deselect_all': 'Deselect All',
        'rssi_power.delete_selected': 'Delete Selected...',
        'rssi_power.zoom': 'Zoom:',
        'rssi_power.live': ' (Live)',
        'rssi_power.graph_power_label': 'Power (dBm)',
        'rssi_power.graph_rssi_label': 'RSSI (dBm)',
        'rssi_power.graph_test_title': 'Test',
        'rssi_power.graph_rssi_vs_power_title': 'RSSI vs Power',
        'rssi_power.graph_no_data': 'No data available',
        'rssi_power.graph_trend_label': 'Trend',
        'rssi_power.graph_trend_slope': 'Trend (slope: {slope})',
        'rssi_power.graph_rssi_vs_power_label': 'RSSI vs Power',
        'rssi_power.graph_info_epc': 'EPC:',
        'rssi_power.graph_info_freq': 'Freq:',
        'rssi_power.graph_info_slope': 'Slope:',
        'rssi_power.graph_error': 'Error generating graph:',
        'rssi_power.success': 'Success',
        'rssi_power.success_report_generated': 'PDF report of selected tests generated successfully!\n\nFile: {filepath}\n\nTests included: {count}',
        'rssi_power.test_completed': 'Test Completed',
        'rssi_power.test_completed_msg': 'Power sweep completed!',
        'rssi_power.test_error': 'Test Error',
        'rssi_power.name_duplicate_inline': 'Duplicate Name',
        'rssi_power.name_duplicate_inline_msg': 'A test with the name \'{name}\' already exists in history.\n\nPlease choose a different name.',
        'rssi_power.no_test_selected_save': 'No Test Selected',
        'rssi_power.no_test_selected_save_msg': 'Select one or more tests in the history to save.',
        'rssi_power.save_tests_title': 'Save Selected Tests',
        'rssi_power.tests_saved_success': '{count} test(s) saved successfully.',
        'rssi_power.error_saving': 'Error Saving',
        'rssi_power.error_saving_msg': 'Could not save.\n{error}',
        'rssi_power.import_tests_title': 'Import Tests',
        'rssi_power.no_tests_in_file': 'No Test Found',
        'rssi_power.no_tests_in_file_msg': 'The file does not contain valid test data.',
        'rssi_power.import_completed': 'Import Completed',
        'rssi_power.import_completed_msg': '{count} test(s) added to history.',
        'rssi_power.import_error': 'Import Error',
        'rssi_power.import_error_msg': 'Failed to import file.\n{error}',
        'rssi_power.db_unavailable_report': 'Warning',
        'rssi_power.db_unavailable_report_msg': 'Database not available to generate report.',
        'rssi_power.no_test_selected_report': 'No Test Selected',
        'rssi_power.no_test_selected_report_msg': 'Please select one or more tests in the history to generate the report.',
        'rssi_power.error_generating_pdf': 'Error',
        'rssi_power.error_generating_pdf_msg': 'Error generating PDF report:\n{error}',
        'rssi_power.error_unexpected_pdf': 'Error generating PDF report:\n{error}',
        'rssi_power.delete_tests_title': 'No Test Selected',
        'rssi_power.delete_tests_msg': 'Select one or more tests in the history to delete.',
        'rssi_power.tests_deleted': 'Success',
        'rssi_power.tests_deleted_msg': '{count} test(s) deleted.',
        'rssi_power.save_pdf_title': 'Save PDF Report',
        'rssi_power.no_valid_test': 'Warning',
        'rssi_power.no_valid_test_msg': 'No valid test found among selected.',
        
        # Constant Power Module
        'constant_power.dll_error': 'DLL Error',
        'constant_power.dll_error_msg': 'File \'UHFRFID.dll\' not found.',
        'constant_power.demo_mode': 'Demo Mode',
        'constant_power.demo_mode_msg': 'This module is running in demo mode.\n\nFor full functionality, add a valid license in the License module.',
        'constant_power.safety_stop_temp': 'Safety Stop',
        'constant_power.safety_stop_temp_msg': 'Temperature ({temp:.1f}°C) exceeded the limit of {limit}°C.\n\nThe test cannot be started for hardware safety.',
        'constant_power.reflected_power_high': 'High Reflected Power',
        'constant_power.reflected_power_high_msg': 'Reflected Power ({power:.1f} dBm) exceeded the limit of {limit} dBm.\n\nCheck the radiating system (antenna).\nThe test cannot be started for hardware safety.',
        'constant_power.invalid_license': 'Invalid License',
        'constant_power.invalid_license_msg': 'No active license found.\n\nTo use this module, activate a valid license in the License module.',
        'constant_power.hardware_unavailable': 'Error',
        'constant_power.hardware_unavailable_msg': 'Hardware not available. Test cancelled.',
        'constant_power.freq_outside_license': 'Frequency outside license ranges',
        'constant_power.freq_outside_license_msg': 'The frequency {freq} MHz is outside the ranges allowed by the license.\n\nAllowed ranges: {allowed}\nExcluded ranges: {excluded}\nEntered frequency: {freq} MHz\n\nAdjust the frequency to be within one of the allowed ranges, avoiding excluded ranges.',
        'constant_power.power_outside_license': 'Power outside license limits',
        'constant_power.power_outside_license_msg': 'The selected power ({power} dBm) is outside the limits allowed by the license.\n\nAllowed limits: {min_power} - {max_power} dBm\nSelected power: {power} dBm\n\nAdjust the power to be within the range allowed by the license.',
        'constant_power.invalid_values': 'Error',
        'constant_power.invalid_values_msg': 'Invalid values in input fields',
        'constant_power.error_starting': 'Error',
        'constant_power.error_starting_msg': 'Error starting test: {error}',
        'constant_power.hardware_not_found': 'Error',
        'constant_power.hardware_not_found_msg': 'Hardware not found. Closing.',
        
        # License Module
        'constant_power.browser_mode': 'browser mode',
        'constant_power.test_config': 'Test Configuration',
        'constant_power.frequency_mhz': 'Frequency (MHz):',
        'constant_power.power_dbm': 'Power (dBm):',
        'constant_power.controls': 'Controls',
        'constant_power.test': 'Test',
        'constant_power.stop': 'Stop',
        'constant_power.pause': '⏸ Pause',
        'constant_power.resume': '▶ Resume',
        'constant_power.clear_graph': 'Clear Graph',
        'constant_power.graph_title': 'RSSI vs Time Graph',
        
        # FastThreshold Module
        'fastthreshold.title': 'FastThreshold - Quick Threshold Measurement',
        'fastthreshold.test_history': 'Test History by Tag',
        'fastthreshold.graph_title': 'Threshold Graph',
        'fastthreshold.statistics': 'Statistical Analysis',
        'fastthreshold.safety_system': 'Safety System',
        'fastthreshold.temperature': 'Temperature:',
        'fastthreshold.vswr': 'VSWR:',
        'fastthreshold.test_config': 'Test Configuration',
        'fastthreshold.test_name': 'Test Name:',
        'fastthreshold.freq_mhz': 'Freq (MHz)',
        'fastthreshold.threshold_dbm': 'Threshold (dBm)',
        'fastthreshold.test': 'Test',
        'fastthreshold.testing': 'Testing...',
        'fastthreshold.testing_tag': 'Testing tag...',
        'fastthreshold.clear': 'Clear',
        'fastthreshold.save': 'Save',
        'fastthreshold.import': 'Import',
        'fastthreshold.report_pdf': 'Report (PDF)',
        'fastthreshold.ready': 'Ready to test',
        'fastthreshold.summary': 'Execution Summary',
        'fastthreshold.tags_tested': 'Tags Tested:',
        'fastthreshold.tags_selected': 'Tags Selected:',
        'fastthreshold.select_all': 'Select All',
        'fastthreshold.deselect_all': 'Deselect All',
        'fastthreshold.delete_selected': 'Delete Selected',
        'fastthreshold.generate_stats': 'Generate Statistics',
        'fastthreshold.export_excel': 'Export to Excel',
        'fastthreshold.test_button': 'Test',
        'fastthreshold.execution_summary': 'Execution Summary',
        'fastthreshold.plot': 'Plot',
        'fastthreshold.tag_epc': 'Tag EPC',
        'fastthreshold.date_time': 'Date/Time',
        'fastthreshold.attention': '⚠️ ATTENTION: Critical conditions detected!',
        'fastthreshold.missing_dependency': 'Missing Dependency',
        'fastthreshold.missing_dependency_msg': 'The \'matplotlib\' library was not found.\nPlease install it with the command:\n\npy -m pip install matplotlib',
        'fastthreshold.dll_critical_error': 'Critical DLL Error',
        'fastthreshold.dll_critical_error_msg': 'Could not load DLL \'{dll}\'.\nMake sure the file is in the same folder as the program.\n\nReason: {error}',
        'fastthreshold.demo_mode_title': 'Demo Mode',
        'fastthreshold.demo_mode_msg': 'This module is running in demo mode.\n\nFor full functionality, add a valid license in the License module.',
        'fastthreshold.error': 'Error',
        'fastthreshold.freq_not_allowed': 'Frequency {n} ({freq} MHz) not permitted by license',
        'fastthreshold.freq_invalid': 'Frequency {n} invalid',
        'fastthreshold.no_freq_configured': 'Configure at least one frequency',
        'fastthreshold.test_error': 'Test error. Try again',
        'fastthreshold.test_name_required': 'Please enter a test name before starting.',
        'fastthreshold.mean': 'Average',
        'fastthreshold.mean_minus_3sigma': 'Average - 3σ',
        'fastthreshold.mean_plus_3sigma': 'Average + 3σ',
        'fastthreshold.freq_unit': '(MHz)',
        'fastthreshold.mean_unit': '(dBm)',
        'fastthreshold.sigma_unit': '(dBm)',
        'fastthreshold.freq_mhz_label': 'Frequency (MHz)',
        'fastthreshold.mean_dbm_label': 'Average (dBm)',
        'fastthreshold.mean_minus_3sigma_label': 'Average - 3σ (dBm)',
        'fastthreshold.mean_plus_3sigma_label': 'Average + 3σ (dBm)',
        'fastthreshold.sigma_dbm_label': 'σ (dBm)',
        'fastthreshold.threshold_dbm_label': 'Threshold (dBm)',
        'fastthreshold.statistical_analysis': 'Statistical Analysis',
        'fastthreshold.duplicate_epc_title': 'Duplicate EPC',
        'fastthreshold.duplicate_epc_msg': 'The tag with EPC {epc} has already been tested previously.\n\nThis entry will be highlighted in red in the history.',
        'fastthreshold.success': 'Success',
        'fastthreshold.error_generic': 'Error',
        'fastthreshold.report_saved': 'Report saved to: {filename}',
        'fastthreshold.error_saving_report': 'Error saving report: {error}',
        'fastthreshold.save_report_title': 'Save Report',
        'fastthreshold.import_report_title': 'Import Report',
        'fastthreshold.json_files': 'JSON Files',
        'fastthreshold.all_files': 'All Files',
        'fastthreshold.report_imported': 'Report imported successfully!',
        'fastthreshold.invalid_file': 'File does not contain valid data',
        'fastthreshold.error_importing_report': 'Error importing report: {error}',
        'fastthreshold.warning': 'Warning',
        'fastthreshold.info': 'Info',
        'fastthreshold.no_tests_for_report': 'No tests in history to generate report.',
        'fastthreshold.no_tests_selected_title': 'No Tests Selected',
        'fastthreshold.no_tests_selected_msg': 'Please select one or more tests from the history to generate the report.',
        'fastthreshold.save_pdf_title': 'Save PDF Report',
        'fastthreshold.pdf_generated': 'PDF report of selected tests generated successfully!\n\nFile: {filepath}\n\nTests included: {count}',
        'fastthreshold.error_generating_pdf': 'Error generating PDF report:\n{error}',
        'fastthreshold.unexpected_error': 'Unexpected error generating report:\n{error}',
        'fastthreshold.no_tests_to_delete': 'No tests in history to delete',
        'fastthreshold.no_tests_selected_delete': 'No tests selected to delete',
        'fastthreshold.confirm_delete_title': 'Confirm Deletion',
        'fastthreshold.confirm_delete_msg': 'Do you really want to delete {count} selected test(s)?\n\nThis action cannot be undone.',
        'fastthreshold.tests_deleted': '{count} test(s) deleted successfully!',
        'fastthreshold.error_deleting_tests': 'Error deleting tests: {error}',
        'fastthreshold.indeterminate_thresholds_title': '⚠️ Warning - Indeterminate Thresholds',
        'fastthreshold.indeterminate_thresholds_msg': '{count} indeterminate threshold(s) were detected in the selected tests.\n\nIndeterminate thresholds: <5 dBm or >25 dBm\n\nRequired action: Remove tags with indeterminate threshold before generating statistical analysis.',
        'fastthreshold.no_data_for_stats': 'No data selected for statistical analysis',
        'fastthreshold.error_generating_stats': 'Error generating statistics: {error}',
        'fastthreshold.no_tests_to_export': 'No tests in history to export.',
        'fastthreshold.export_excel_title': 'Export to Excel',
        'fastthreshold.excel_files': 'Excel Files',
        'fastthreshold.excel_2003': 'Excel 2003',
        'fastthreshold.openpyxl_not_found': 'Library \'openpyxl\' not found.\nPlease install with: pip install openpyxl',
        'fastthreshold.excel_exported': 'Data exported successfully to Excel!\n\nFile: {filepath}\n\nSheets included:\n- Test History\n- Statistical Analysis',
        'fastthreshold.error_exporting_excel': 'Error exporting to Excel:\n{error}',
        'fastthreshold.test_cancelled': 'Test cancelled.',
        'fastthreshold.test_completed': 'Test completed! Ready to test another tag',
        'fastthreshold.ready': 'Ready to test',
        'fastthreshold.generating_pdf': 'Generating PDF report...',
        'fastthreshold.pdf_generated_success': 'PDF report generated successfully!',
        'fastthreshold.error_generating_pdf_status': 'Error generating PDF report',
        'fastthreshold.exporting_excel': 'Exporting to Excel...',
        'fastthreshold.excel_export_completed': 'Export completed successfully!',
        'fastthreshold.error_exporting_excel_status': 'Error exporting to Excel',
        'fastthreshold.attention_critical': '⚠️ ATTENTION: Critical conditions detected!',
        'fastthreshold.system_safe': '✅ System safe',
        'fastthreshold.pdf_files': 'PDF Files',
        
        # Noise Check Module
        'noise.test_config': 'Test Configuration',
        'noise.name': 'Name:',
        'noise.time_s': 'Time (s):',
        'noise.mode': 'Mode:',
        'noise.single': 'Single',
        'noise.continuous': 'Continuous',
        'noise.controls': 'Controls',
        'noise.test': 'Test',
        'noise.stop': 'Stop',
        'noise.clear_plot': 'Clear Graph',
        'noise.save_selected': 'Save Selected',
        'noise.import_tests': 'Import Tests',
        'noise.report_pdf': 'Report Selected (PDF)',
        'noise.test_history': 'Test History',
        'noise.stats_loading': 'Statistics: Loading...',
        'noise.plot': 'Plot',
        'noise.id': 'ID',
        'noise.test_name': 'Test Name',
        'noise.duration': 'Duration (s)',
        'noise.avg_noise': 'Average Noise (dBm)',
        'noise.min_noise': 'Min Noise (dBm)',
        'noise.max_noise': 'Max Noise (dBm)',
        'noise.max_noise_time': 'Max Noise Time',
        'noise.date_time': 'Date/Time',
        'noise.severity': 'Severity',
        'noise.select_all': 'Select All',
        'noise.deselect_all': 'Deselect All',
        'noise.delete_selected': 'Delete Selected...',
        'noise.stats_format': 'Statistics: {count} tests | Total duration: {duration:.1f}s | Average noise: {avg_noise:.1f} dBm',
        'noise.stats_format_single': 'Statistics: {count} test | Total duration: {duration:.1f}s | Average noise: {avg_noise:.1f} dBm',
        'noise.stats_db_unavailable': 'Statistics: Database unavailable',
        'noise.stats_load_error': 'Statistics: Error loading ({error})',
        'noise.x_axis_label': 'Time (s)',
        'noise.y_axis_label': 'Strength (dBm)',
        'noise.severity_low': 'Low',
        'noise.severity_medium': 'Medium',
        'noise.severity_high': 'High',
        'noise.severity_very_high': 'Very High',
        'noise.severity_low_desc': 'Stable noise, low variation - Ideal environment',
        'noise.severity_medium_desc': 'Moderate noise variation - Acceptable',
        'noise.severity_high_desc': 'Significant noise variation - May affect performance',
        'noise.severity_very_high_desc': 'Extreme noise variation - Operation compromised',
        'noise.severity_help_title': 'Noise Severity Definition',
        'noise.severity_criteria_title': 'Severity Classification Criteria',
        'noise.severity_formula': 'Severity = Maximum Noise - Average Noise',
        'noise.severity_info': '• Average Noise: Arithmetic mean of all collected values\n• Maximum Noise: Highest value recorded during the test\n• Classification is automatically applied to tests',
        
        # Antenna Check Module
        'antenna.test_config': 'Test Configuration',
        'antenna.name': 'Name:',
        'antenna.power_dbm': 'Power (dBm):',
        'antenna.graph': 'Graph:',
        'antenna.curve': 'Curve:',
        'antenna.frequency_mhz': 'Frequency (MHz):',
        'antenna.min': 'Min:',
        'antenna.max': 'Max:',
        'antenna.step_mhz': 'Step (MHz):',
        'antenna.controls': 'Controls',
        'antenna.test': 'Test',
        'antenna.stop': 'Stop',
        'antenna.clear_plot': 'Clear Graph',
        'antenna.save_selected': 'Save Selected',
        'antenna.import_tests': 'Import Tests',
        'antenna.report_pdf': 'Report Selected (PDF)',
        'antenna.test_history': 'Test History',
        'antenna.stats_loading': 'Statistics: Loading...',
        'antenna.plot': 'Plot',
        'antenna.name_col': 'Name',
        'antenna.power': 'Power (dBm)',
        'antenna.freq_range': 'Freq Range (MHz)',
        'antenna.min_return_loss': 'Min Return Loss (dBm)',
        'antenna.vswr': 'VSWR',
        'antenna.best_freq': 'Best Freq (MHz)',
        'antenna.date_time': 'Date/Time',
        'antenna.select_all': 'Select All',
        'antenna.deselect_all': 'Deselect All',
        'antenna.delete_selected': 'Delete Selected...',
        'antenna.import_tests_dialog': 'Import Antenna Tests',
        'antenna.save_tests_dialog': 'Save Selected Tests',
        'antenna.import_tests_title': 'Import Tests',
        'antenna.save_pdf_title': 'Save PDF Report',
        'antenna.standalone_title': 'Isolated Test - Antenna Module',
        'antenna.curve_point': 'Point Curve',
        'antenna.curve_smooth': 'Smooth Curve',
        'antenna.stats_format': 'Statistics: {count} tests in history',
        'antenna.stats_format_single': 'Statistics: {count} test in history',
        'antenna.x_axis_label': 'Frequency (MHz)',
        'antenna.y_axis_return_loss': 'Return Loss (dBm)',
        'antenna.y_axis_vswr': 'VSWR',
        'antenna.y_axis_impedance': 'Impedance (Ω)',
        'antenna.y_axis_return_loss': 'Return Loss (dB)',
        'antenna.y_axis_vswr': 'VSWR',
        
        # FastSurance Module
        'fastsurance.title': 'RFID Reader Control and Report',
        'fastsurance.safety_system': 'Safety System',
        'fastsurance.temperature': 'Temperature:',
        'fastsurance.vswr': 'VSWR:',
        'fastsurance.epc_filter': 'EPC Filter',
        'fastsurance.tag_registration': '🔍 Tag Registration',
        'fastsurance.scanning': '🔍 Inventorying...',
        'fastsurance.selected_epc': 'Selected EPC / RSSI:',
        'fastsurance.click_to_load': 'Click on \'Tag Registration\' to load',
        'fastsurance.no_epc_selected': 'No EPC selected',
        'fastsurance.license_required': '⚠ License required for Threshold',
        'fastsurance.test_type': 'Test Type',
        'fastsurance.gonogo': 'Go/NoGo',
        'fastsurance.threshold': 'Threshold',
        'fastsurance.use_attenuator': 'Use attenuator',
        'fastsurance.test_config': 'Test Configuration',
        'fastsurance.freq_mhz': 'Freq (MHz)',
        'fastsurance.threshold_dbm': 'Threshold (dBm)',
        'fastsurance.test': 'Test',
        'fastsurance.start_execution': 'Start Execution',
        'fastsurance.testing': 'Test',
        'fastsurance.checking': 'Checking...',
        'fastsurance.clear': 'Clear',
        'fastsurance.save': 'Save',
        'fastsurance.import': 'Import',
        'fastsurance.import_from_threshold': 'Import from Threshold',
        'fastsurance.report_pdf': 'Report (PDF)',
        'fastsurance.execution_summary': 'Execution Summary',
        'fastsurance.tags_tested': 'Tags Tested:',
        'fastsurance.approved': 'Approved:',
        'fastsurance.rejected': 'Rejected:',
        'fastsurance.yield': 'Yield (%):',
        'fastsurance.graph': 'Graph',
        'fastsurance.test_history': 'Test History',
        'fastsurance.last_test': 'Last Test',
        'fastsurance.failure_distribution': 'Failure Distribution by Test',
        'fastsurance.pareto_chart': 'Pareto Chart of Failures',
        'fastsurance.browser_mode': ' browser mode',
        'fastsurance.no_tags_found': 'No tags found',
        'fastsurance.epc_selected': 'EPC selected',
        'fastsurance.epc_column': 'Tag EPC',
        'fastsurance.result_column': 'General Result',
        'fastsurance.failures_column': 'Failures (MHz)',
        'fastsurance.datetime_column': 'Date/Time',
        'fastsurance.passed': 'PASSED',
        'fastsurance.failed': 'FAILED',
        'fastsurance.test': 'Test',
        'fastsurance.number_of_failures': 'Number of Failures',
        'fastsurance.accumulated': 'Accumulated (%)',
        'fastsurance.accumulated_percent': 'Accumulated Percent (%)',
        'fastsurance.frequency_label': 'Frequency (MHz)',
        'fastsurance.threshold_label': 'Threshold (dBm)',
        'fastsurance.test_number': 'Test {n}',
        'fastsurance.freq_number': 'Frequency {n}',
        'fastsurance.no_epc_selected': 'EPC Not Selected',
        'fastsurance.no_epc_selected_msg': 'Select an EPC for the test.',
        'fastsurance.no_test_config': 'No test configured.',
        'fastsurance.no_reference_tag': 'Could not find a reference tag for the test.',
        'fastsurance.temp_critical': 'Critical temperature: {temp}°C. Test blocked for hardware safety.',
        'fastsurance.reflected_power_high': 'High Reflected Power: {power} dBm. Check the radiating system.',
        'fastsurance.comm_error_reflected': 'Initial communication failure: Reflected Power',
        'fastsurance.comm_error_temp': 'Initial communication failure: Temperature',
        'fastsurance.heating_failed': 'Heating cycle execution failure',
        'fastsurance.validation_error_freq': 'Test {n}: Frequency {freq} MHz outside allowed license ranges.\n\nAllowed ranges: {ranges}\nExcluded ranges: {excluded}\nAttempted frequency: {freq} MHz',
        'fastsurance.validation_error_power': 'Test {n}: Power {power}dBm outside license limits ({min}-{max}dBm).',
        'fastsurance.validation_error_freq_invalid': 'Test {n}: Invalid frequency.',
        'fastsurance.validation_error_freq_threshold': 'Frequency {n}: {freq}MHz outside allowed license ranges.\n\nAllowed ranges: {ranges}\nExcluded ranges: {excluded}\nAttempted frequency: {freq} MHz',
        'fastsurance.validation_error_freq_threshold_invalid': 'Frequency {n}: Invalid.',
        'fastsurance.clear_confirm': 'Are you sure you want to clear the CONFIGURATION and REPORT DATA from this screen?',
        'fastsurance.no_data_to_save': 'No data to save.',
        'fastsurance.save_success': 'Report successfully saved to:\n{path}',
        'fastsurance.save_error': 'An error occurred while trying to save the file.\n\nDetails: {error}',
        'fastsurance.select_report': 'Select report',
        'fastsurance.read_error': 'Could not read the file.\n\nDetails: {error}',
        'fastsurance.invalid_file': 'The file is not a valid report.',
        'fastsurance.import_confirm': 'This will replace the current data. Do you want to continue?',
        'fastsurance.import_success_tags': 'Tag Tests report imported.',
        'fastsurance.import_success_threshold': 'Threshold report imported.',
        'fastsurance.import_error': 'An error occurred while processing the report.\n\nDetails: {error}',
        'fastsurance.no_threshold_data': 'No threshold data available to generate report.',
        'fastsurance.no_tags_selected': 'No tags selected for the report.',
        'fastsurance.pdf_success': 'Threshold PDF report generated successfully!\n\nFile: {path}',
        'fastsurance.pdf_error': 'Error generating PDF report:\n{error}',
        'fastsurance.demo_mode': 'This module is running in demo mode.\n\nFor full functionality, add a valid license in the License module.',
        'fastsurance.use_attenuator': 'Use attenuator',
        'fastsurance.no_threshold_to_migrate': 'No threshold results to migrate.',
        'fastsurance.migrate_confirm': 'This will overwrite the current Frequency and Power values. Do you want to continue?',
        'fastsurance.migrate_success': 'Threshold test data migrated successfully.',
        'fastsurance.invalid_threshold': 'Could not determine threshold.\n\nFound values are outside valid range:\n• Minimum: {min} dBm\n• Maximum: {max} dBm\n\nRun the threshold test again to get valid values.',
        'fastsurance.no_tags_test_data': 'No tag test data available to generate report.',
        'fastsurance.missing_dependency': 'Missing Dependency',
        'fastsurance.missing_dependency_msg': 'The \'matplotlib\' library was not found.\nPlease install it with the command:\n\npy -m pip install matplotlib',
        'fastsurance.dll_critical_error': 'Critical DLL Error',
        'fastsurance.dll_critical_error_msg': 'Could not load DLL \'{dll}\'.\nMake sure the file is in the same folder as the program.\n\nReason: {error}',
        'fastsurance.error': 'Error',
        'fastsurance.help_file_not_found': 'Help file \'{file}\' not found.',
        'fastsurance.demo_mode_title': 'Demo Mode',
        'fastsurance.success': 'Success',
        'fastsurance.save_report_title': 'Save PDF Report',
        'fastsurance.tags_pdf_success': 'Tag tests PDF report generated successfully!\n\nFile: {path}',
        'fastsurance.pdf_generation_error': 'Error generating PDF report:\n{error}',
        'fastsurance.unknown_error': 'Unknown error',
        
        # Threshold Module
        'threshold.x_axis_label': 'Frequency (MHz)',
        'threshold.test': 'Test',
        'threshold.y_axis_module_power': 'Module Power (dBm)',
        'threshold.y_axis_module_rssi': 'Module RSSI (dBm)',
        'threshold.y_axis_irradiated_power': 'Irradiated Power (dBm)',
        'threshold.y_axis_backscatter': 'Backscatter (dBm)',
        'threshold.y_axis_power_tag_forward': 'Power on Tag Forward (dBm)',
        'threshold.y_axis_power_tag_reversed': 'Power on Tag Reversed (dBm)',
        'threshold.y_axis_conversion_loss': 'Conversion Loss (dBm)',
        'threshold.y_axis_max_fcc_link_forward': 'Max FCC Link Forward (m)',
        'threshold.y_axis_max_fcc_link_reversed': 'Max FCC Link Reversed (m)',
        'threshold.y_axis_rcs': 'RCS (dBm²)',
        # Valores para dropdowns de tipo de gráfico
        'threshold.graph_type_module_power': 'Module Power (dBm)',
        'threshold.graph_type_module_rssi': 'Module RSSI (dBm)',
        'threshold.graph_type_irradiated_power': 'Irradiated Power (dBm)',
        'threshold.graph_type_backscatter': 'Backscatter (dBm)',
        'threshold.graph_type_power_tag_forward': 'Power on Tag Forward (dBm)',
        'threshold.graph_type_power_tag_reversed': 'Power on Tag Reversed (dBm)',
        'threshold.graph_type_conversion_loss': 'Conversion Loss (dBm)',
        'threshold.graph_type_max_fcc_link_forward': 'Max FCC Link Forward (m)',
        'threshold.graph_type_max_fcc_link_reversed': 'Max FCC Link Reversed (m)',
        'threshold.graph_type_rcs': 'RCS (dBm²)',
        'threshold.no_tags_registered': '(No tags registered)',
        'threshold.failed': 'FAILED',
        'threshold.safety_system': 'Safety System',
        'threshold.temperature': 'Temperature:',
        'threshold.vswr': 'VSWR:',
        'threshold.browser_mode': 'browser mode',
        'threshold.register_new_tags': '+ Register New Tags',
        'threshold.import_tag_json': '+ Import Tag from file JSON',
        'threshold.select_all_tags': '+ Select All Tags',
        'threshold.deselect_all_tags': '+ Deselect All Tags',
        'threshold.erase_selected_tags': '- Erase Selected Tags',
        'threshold.save_selected_tags': '> Save Selected Tags (JSON)',
        'threshold.registered_tags': 'Registered Tags',
        'threshold.project': 'Project',
        'threshold.saved': 'saved successfully',
        'threshold.deleted': 'deleted successfully',
        'threshold.file': 'File',
        'threshold.tags': 'Tags',
        'threshold.tests': 'Tests',
        'threshold.cleared': 'Cleared',
        'threshold.parameters': 'Parameters',
        'threshold.reset': 'Reset',
        'threshold.project_name': 'Name:',
        'threshold.client': 'Client:',
        'threshold.save': 'Save',
        'threshold.clear': 'Clear',
        'threshold.import': 'Import',
        'threshold.test_config': 'Test Configuration',
        'threshold.freq_mhz': 'Freq. (MHz):',
        'threshold.to': 'to',
        'threshold.power_dbm': 'Power (dBm):',
        'threshold.freq_step': 'Freq. Step (MHz):',
        'threshold.power_step': 'Power Step (dBm):',
        'threshold.distance': 'Distance (m):',
        'threshold.attenuator': 'Attenuator (dB):',
        'threshold.description': 'Description:',
        'threshold.start_test': 'Start Test',
        'threshold.cancel_test': 'Cancel Test',
        'threshold.show_table': 'Show Table',
        'threshold.pdf_report': 'Selected Report (PDF)',
        'threshold.test_history': 'Test History',
        'threshold.tests_count': '({count} tests)',
        'threshold.test_count_single': '({count} test)',
        'threshold.plot': 'Plot ↕',
        'threshold.test_name': 'Test Name ✏️ ↕',
        'threshold.epc': 'EPC ↕',
        'threshold.attenuator_col': 'Attenuator ↕',
        'threshold.distance_col': 'Distance ↕',
        'threshold.date_time': 'Date/Time ↕',
        'threshold.time': 'Time (s) ↕',
        'threshold.multiple_tests_title': 'Multiple Marked Tests',
        'threshold.multiple_tests_msg': 'There are {count} tests marked for graphs.\n\nTo show the table of a specific test:\n1. Click on the \'Description\' column of the desired test in the history\n2. The test will be highlighted in blue\n3. Click on \'Show Table\' again\n\nMarked tests:\n{marked_list}\n\nDo you want to unmark all tests to start from scratch?',
        'threshold.no_test_selected_title': 'No Test Selected',
        'threshold.no_test_selected_msg': 'Please select a test to show its table.\n\nTo select a test:\n1. Click on the \'Description\' column of the desired test in the history\n2. The test will be highlighted in blue\n3. Click on \'Show Table\' again\n\nOR\n\n1. Mark a test in the ☐ checkbox in the \'Plot\' column of the history\n2. The checkbox should change to ☑\n3. Click on \'Show Table\' (if it is the only one marked)',
        'threshold.no_results_title': 'No Results',
        'threshold.no_results_msg': 'The test \'{test_desc}\' has no results to show.\n\nPossible causes:\n• Test was interrupted before completion\n• Error during test execution\n• Corrupted data in database',
        'threshold.yes': 'Yes',
        'threshold.no': 'No',
        'threshold.select_an_action': 'Select an action',
        # Valores para dropdown de ações da tabela
        'threshold.table_select_all': 'Select All Tests',
        'threshold.table_deselect_all': 'Deselect All Tests',
        'threshold.table_statistical': 'Statistical Calculation of Selected',
        'threshold.table_delete_selected': 'Delete Selected Tests',
        'threshold.table_export_excel': 'Export Selected to Excel',
        'threshold.error': 'Error',
        'threshold.error_invalid_parameters': 'Invalid parameters. Check the numeric values.',
        'threshold.error_hardware': 'Hardware Error',
        'threshold.error_hardware_not_detected': 'Hardware not detected.',
        'threshold.error_hardware_connection': 'Error connecting hardware (COM{port})\nCheck the connection.',
        'threshold.error_hardware_init': 'Initialization error: {error}',
        'threshold.error_hardware_port': 'Error opening COM port {port}',
        'threshold.error_hardware_port_exception': 'Exception opening COM port: {error}',
        'threshold.warning_hardware': 'Hardware',
        'threshold.warning_matplotlib': 'Matplotlib Missing',
        'threshold.warning_matplotlib_msg': 'Install \'matplotlib\' with: pip install matplotlib',
        'threshold.warning_db_unavailable': 'Database unavailable to generate report.',
        'threshold.warning_no_test_selected_report': 'No Test Selected',
        'threshold.warning_no_test_selected_report_msg': 'Please select one or more tests from the history to generate the report.',
        'threshold.warning_no_valid_test': 'No valid test found among the selected.',
        'threshold.success': 'Success',
        'threshold.success_report_generated': 'PDF report of selected tests generated successfully!\n\nFile: {filepath}\n\nTests included: {count}',
        'threshold.error_generating_pdf': 'Error generating PDF report:\n{error}',
        'threshold.error_unexpected_report': 'Unexpected error generating report:\n{error}',
        'threshold.error_invalid_json': 'Invalid JSON file format.\n\nType found: {type}\nExpected: list of tags or object with \'tags\' property.\n\nContent: {content}...',
        'threshold.error_reading_file': 'Read Error',
        'threshold.error_reading_file_msg': 'Could not read the file:\n{error}',
        'threshold.info_import_summary': 'Import Summary',
        'threshold.warning_no_selection': 'No Selection',
        'threshold.warning_no_selection_msg': 'Please select at least one tag to remove.',
        'threshold.success_tags_removed': '{count} tag(s) removed successfully.',
        'threshold.warning_some_tags_not_removed': 'Warning',
        'threshold.warning_some_tags_not_removed_msg': '{removed} of {total} tag(s) were removed.\nSome tags may not have been found in the database.',
        'threshold.warning_no_selection_save': 'Please select at least one tag to save.',
        'threshold.success_tags_saved': '{count} tag(s) saved successfully to:\n{filepath}',
        'threshold.error_saving_file': 'Error saving file:\n{error}',
        'threshold.info_test_selected': 'Test Selected',
        'threshold.test_selected': 'Test selected',
        'threshold.test_selected_msg': 'You can now click \'Show Table\' or use \'View Table Directly\'.',
        'threshold.warning_no_results': 'No Results',
        'threshold.error_showing_table': 'Error showing table: {error}',
        'threshold.success_tag_deleted': 'Tag deleted successfully.',
        'threshold.error_deleting_tag': 'Could not delete the tag from the database.',
        'threshold.warning_project_name': 'Project Name',
        'threshold.warning_project_name_msg': 'Please enter a name for the project.',
        'threshold.success_project_saved': 'Project Saved',
        'threshold.error_saving_project': 'Error saving project: {error}',
        'threshold.warning_no_project_selected_delete': 'Project',
        'threshold.warning_no_project_selected_delete_msg': 'No project selected to delete.',
        'threshold.success_project_deleted': 'Project Deleted',
        'threshold.error_deleting_project': 'Error deleting project.',
        'threshold.error_deleting_project_exception': 'Error deleting project: {error}',
        'threshold.error_invalid_file': 'Invalid File',
        'threshold.error_invalid_file_msg': 'The file does not contain a valid project.',
        'threshold.success_project_imported': 'Project Imported',
        'threshold.error_file_not_found': 'File not found.',
        'threshold.error_invalid_json_file': 'Invalid JSON file.',
        'threshold.error_importing_project': 'Error importing project: {error}',
        'threshold.warning_no_project_selected_export': 'Project',
        'threshold.warning_no_project_selected_export_msg': 'No project selected to export.',
        'threshold.error_project_not_found': 'Project \'{name}\' not found in database.',
        'threshold.success_project_exported': 'Project Exported',
        'threshold.success_project_exported_msg': 'Project \'{project_name}\' exported successfully!\n\nFile: {filename}\n[DATA] Tags: {tags_count}\n[INFO] Tests: {tests_count}',
        'threshold.error_exporting_project': 'Error exporting project: {error}',
        'threshold.success_project_imported_msg': '[OK] PROJECT IMPORTED SUCCESSFULLY!\n\n[DATA] Name: {project_name}\n👤 Client: {client_name}\n[DATA] Tags: {tags_imported}\n[INFO] Tests: {tests_imported}\n⚙️ Settings: Updated\n📁 Source: {filename}\n\n[OK] Imported tags were automatically selected!',
        'threshold.not_specified': 'Not specified',
        'threshold.no_results': 'No Results',
        'threshold.no_results_msg': 'The test \'{test_desc}\' has no results.',
        'threshold.save_completed': 'Save Completed',
        'threshold.save_completed_msg': 'Results saved to: {filename}',
        'threshold.error_saving_results': 'Error Saving',
        'threshold.error_saving_results_msg': 'Error saving results: {error}',
        'threshold.warning_browser_mode': 'Browser Mode',
        'threshold.warning_browser_mode_msg': 'Test function unavailable without active license.',
        'threshold.warning_no_selection_test': 'No Selection',
        'threshold.warning_no_selection_test_msg': 'Please select exactly one tag to test.',
        'threshold.warning_multiple_tags': 'Multiple Tags',
        'threshold.warning_multiple_tags_msg': 'Please select only one tag for the threshold test.',
        'threshold.error_tag_not_found': 'Selected tag not found.',
        'threshold.info_no_test_cancel': 'Information',
        'threshold.info_no_test_cancel_msg': 'No test is running to cancel.',
        'threshold.error_hardware_connect': 'Hardware Error',
        'threshold.error_hardware_connect_msg': 'Could not open COM port {port}',
        'threshold.error_hardware_init': 'Hardware Error',
        'threshold.error_hardware_init_msg': 'Exception opening COM port: {error}',
        'threshold.selections_cleared': 'Selections Cleared',
        'threshold.selections_cleared_msg': 'All test selections were cleared successfully!\n\n• {count} tests unmarked\n• Interface synchronized\n• Graphs updated',
        'threshold.error_test_not_found': 'Error',
        'threshold.error_test_not_found_msg': 'Test with ID {id} not found.',
        'threshold.error_description_empty': 'Empty Description',
        'threshold.error_description_empty_msg': 'Please enter a valid description for the test.',
        'threshold.error_test_not_found_select': 'Error',
        'threshold.error_test_not_found_select_msg': 'Test not found for selection.',
        'threshold.error_invalid_attenuator': 'Invalid Value',
        'threshold.error_invalid_attenuator_msg': 'Please enter a valid numeric value for the attenuator.',
        'threshold.error_invalid_distance': 'Invalid Value',
        'threshold.error_invalid_distance_msg': 'Please enter a valid numeric value for the distance.',
        'threshold.export_completed': 'Export Completed',
        'threshold.export_completed_msg': 'Data exported to: {filename}',
        'threshold.export_error': 'Export Error',
        'threshold.export_error_msg': 'Error exporting data: {error}',
        'threshold.no_test_selected_average': 'No Test Selected',
        'threshold.no_test_selected_average_msg': 'Please select at least one test to calculate the average.',
        'threshold.only_one_test': 'Only 1 Test',
        'threshold.only_one_test_msg': 'At least 2 tests are required to calculate the average.',
        'threshold.error_no_freq': 'Error',
        'threshold.error_no_freq_msg': 'No valid frequency found in selected tests.',
        'threshold.error_save_average': 'Error',
        'threshold.error_save_average_msg': 'Failed to save average to database',
        'threshold.average_calculated': 'Average Calculated',
        'threshold.average_calculated_msg': 'Average of {count} tests calculated and added to history!',
        'threshold.no_test_selected_statistics': 'No Test Selected',
        'threshold.no_test_selected_statistics_msg': 'Please select at least one test for statistical analysis.',
        'threshold.statistics_complete': 'Complete Statistical Analysis Completed',
        'threshold.statistics_complete_msg': 'Complete statistical analysis of {count} tests completed!\n\n[OK] {success}/4 tests created:\n• Average of {count} tests\n• Standard Deviation of {count} tests\n• Minimum Limit of {count} tests\n• Maximum Limit of {count} tests\n\nAll can be plotted on graphs when selected!',
        'threshold.error_save_statistics': 'Error',
        'threshold.error_save_statistics_msg': 'Failed to save all statistical tests to database',
        'threshold.invalid_selection_edit': 'Invalid Selection',
        'threshold.invalid_selection_edit_msg': 'Please select exactly 1 test to edit the description.',
        'threshold.error_create_dir': 'Error',
        'threshold.error_create_dir_msg': 'Could not create directory:\n{error}',
        'threshold.save_completed': 'Save Completed',
        'threshold.import_completed': 'Import Completed',
        'threshold.import_completed_msg': '{imported} of {total} test(s) imported successfully!\nTotal tests in history: {history_count}',
        'threshold.error_import': 'Import Error',
        'threshold.error_import_msg': 'Error importing tests: {error}',
        'threshold.invalid_file': 'Invalid File',
        'threshold.invalid_file_msg': 'The file does not contain valid test data.',
        'threshold.error_freq_min_max': 'Error',
        'threshold.error_freq_min_max_msg': 'Minimum frequency must be less than maximum.',
        'threshold.error_steps': 'Error',
        'threshold.error_steps_msg': 'Steps must be greater than zero.',
        'threshold.settings_applied': 'Settings Applied',
        'threshold.settings_applied_msg': 'Settings updated successfully!',
        'threshold.error_invalid_values': 'Error',
        'threshold.error_invalid_values_msg': 'Please enter valid numeric values.',
        'threshold.safety_check_failed': 'Safety Check Failed',
        'threshold.safety_check_failed_msg': 'Pre-test safety verification failed:\n\n{error}\n\nThe test cannot be executed for safety reasons.',
        'threshold.safety_stop': 'Safety Stop',
        'threshold.safety_stop_msg': 'Test interrupted for safety:\n{reason}',
        'threshold.error_license_limit': 'License Limit',
        'threshold.error_license_limit_msg': '{message}',
        'threshold.error_save_no_tests': 'Save Error',
        'threshold.error_save_no_tests_msg': 'No tests were saved. Check the logs.',
        'threshold.no_test_selected_export': 'No Test Selected',
        'threshold.no_test_selected_export_msg': 'Please select at least one test using the table checkboxes.',
        'threshold.no_test_selected_save': 'No Test Selected',
        'threshold.no_test_selected_save_msg': 'Please select at least one test to save.',
        'threshold.error_library_required': 'Required Library',
        'threshold.error_library_required_msg': 'To export to Excel, install:\n\npip install openpyxl pandas\n\nError: {error}',
        'threshold.error_export_excel': 'Export Error',
        'threshold.error_export_excel_msg': 'Error exporting to Excel:\n{error}',
        'threshold.error_invalid_file_list': 'Invalid File',
        'threshold.error_invalid_file_list_msg': 'The file must contain a list of tests.',
        'threshold.error_load_data': 'Error',
        'threshold.error_load_data_msg': 'Error loading test data.',
        'threshold.error_load_data_exception': 'Load Error',
        'threshold.error_load_data_exception_msg': 'Error loading data: {error}',
        'threshold.save_success_detail': '{count} test(s) saved successfully!\n\nDirectory: {dir}\n\nSaved files:\n{files}',
        'threshold.export_excel_success': 'Complete database exported!\n\nTests: {count}\nData rows: {rows}\nFile: {filename}',
        'threshold.import_success_detail': '{imported} of {total} test(s) imported successfully!\nTotal tests in history: {history_count}',
        'threshold.data_loaded_success': 'Data Loaded',
        'threshold.data_loaded_success_msg': 'Test results loaded successfully!',
        'threshold.error_steps_msg': 'Steps must be greater than zero.',
        'threshold.error_license_limit': 'License Limit',
        'threshold.error_min_freq_below': 'Minimum frequency {freq} MHz is below the active license limit.\n\nLicense allows: {min_allowed} to {max_allowed} MHz\nPlease enter a value between {min_allowed} and {max_allowed} MHz.',
        'threshold.error_min_freq_above': 'Minimum frequency {freq} MHz is above the active license limit.\n\nLicense allows: {min_allowed} to {max_allowed} MHz\nPlease enter a value between {min_allowed} and {max_allowed} MHz.',
        'threshold.error_max_freq_above': 'Maximum frequency {freq} MHz is above the active license limit.\n\nLicense allows: {min_allowed} to {max_allowed} MHz\nPlease enter a value between {min_allowed} and {max_allowed} MHz.',
        'threshold.error_max_freq_below': 'Maximum frequency {freq} MHz is below the active license limit.\n\nLicense allows: {min_allowed} to {max_allowed} MHz\nPlease enter a value between {min_allowed} and {max_allowed} MHz.',
        
        # PDF Report Translations (English)
        'pdf.report_title_threshold': 'Test Report - Threshold',
        'pdf.system_info': 'System Information',
        'pdf.software': 'Software:',
        'pdf.hardware': 'Hardware:',
        'pdf.firmware': 'Firmware:',
        'pdf.serial_number': 'Serial Number:',
        'pdf.license': 'License:',
        'pdf.generated_at': 'Generated at:',
        'pdf.test_description_title': 'Test Description',
        'pdf.test_description_text': 'This report contains the results of threshold tests performed by FastChecker II. The tests evaluate RFID system sensitivity through analysis of the relationship between transmission power and tag read rate, providing essential data for RFID system performance optimization.',
        'pdf.test_configuration': 'Test Configuration',
        'pdf.min_frequency': 'Minimum Frequency:',
        'pdf.max_frequency': 'Maximum Frequency:',
        'pdf.max_power': 'Maximum Power:',
        'pdf.freq_step': 'Frequency Step:',
        'pdf.power_step': 'Power Step:',
        'pdf.distance': 'Distance:',
        'pdf.attenuator': 'Attenuator:',
        'pdf.test_summary': 'Test Summary',
        'pdf.plot': 'Plot',
        'pdf.test_name': 'Test Name',
        'pdf.epc': 'EPC',
        'pdf.attenuator_col': 'Attenuator',
        'pdf.distance_col': 'Distance',
        'pdf.date_time': 'Date/Time',
        'pdf.duration': 'Duration (s)',
        'pdf.test_charts': 'Test Charts',
        'pdf.chart_error': '(Error generating)',
        'pdf.chart_unavailable': 'Could not generate the chart.',
        'pdf.no_data_available': 'No data available for this chart type',
        'pdf.additional_info': 'Additional Information',
        'pdf.footer_text': 'This report was automatically generated by FastChecker II.<br/>Professional RFID analysis and testing system.<br/>For technical support, consult the system documentation.',
        'pdf.document_generated_at': 'Document generated at:',
        'pdf.etsi_band': 'ETSI 865-868 MHz',
        'pdf.anatel_band_1': 'ANATEL 902-907 MHz',
        'pdf.anatel_band_2': 'ANATEL 915.5-928 MHz',
        # Orientation Report
        'orientation.report_title': 'Report - Fast Orientation',
        'orientation.tests_summary': 'Selected Tests Summary',
        'orientation.no_tests': 'No tests selected in the database.',
        'orientation.polar_chart_title': 'Current Polar Chart',
        'orientation.test_details_title': 'Test Details: {name}',
        'orientation.detail.epc_line': '<b>EPC:</b> {value}',
        'orientation.detail.angle_range_line': '<b>Angle Range:</b> {start}° to {end}°',
        'orientation.detail.step_line': '<b>Step:</b> {value}°',
        'orientation.detail.frequency_line': '<b>Frequency:</b> {value} MHz',
        'orientation.detail.angular_opening_line': '<b>Angular Width:</b> {value}',
        'orientation.detail.main_lobe_line': '<b>Main Lobe Direction:</b> {value}',
        'orientation.detail.timestamp_line': '<b>Date/Time:</b> {value}',
        'orientation.detail.points_line': '<b>Total measurements:</b> {value}',
        'orientation.no_measurements': 'No measurements recorded for this test.',
        'orientation.live_section_title': 'Current / Recent Test',
        'orientation.live_section_description': 'The report includes the history recorded during the current module session.',
        'orientation.live_section_no_data': 'No recent data available.',
        'orientation.auto_report_note': 'Automated report generated by FastChecker II - Fast Orientation module.',
        'orientation.setup.frequency': 'Frequency (MHz)',
        'orientation.setup.start_angle': 'Start Angle (°)',
        'orientation.setup.end_angle': 'End Angle (°)',
        'orientation.setup.step': 'Step (°)',
        'orientation.setup.selected_epc': 'Selected EPC',
        'orientation.setup.test_name': 'Test Name',
        'orientation.table.test_name': 'Test Name',
        'orientation.table.epc': 'EPC',
        'orientation.table.start_angle': 'Start Angle (°)',
        'orientation.table.end_angle': 'End Angle (°)',
        'orientation.table.step': 'Step (°)',
        'orientation.table.frequency': 'Freq (MHz)',
        'orientation.table.angular_opening': 'Angular Width (°)',
        'orientation.table.main_lobe': 'Main Lobe (°)',
        'orientation.table.timestamp': 'Date/Time',
        'orientation.table.points': 'Points',
        'orientation.measurement.angle': 'Angle (°)',
        'orientation.measurement.threshold': 'Threshold',
        'orientation.not_available': 'N/A',
        
        # Noise Module PDF (English)
        'pdf.report_title_noise': 'Test Report - Noise Check',
        'pdf.test_description_title_noise': 'Test Description',
        'pdf.test_description_text_noise': 'This report presents the ambient noise measurements collected by the Noise Check module of FastChecker II. The analysis highlights minimum, average, and maximum noise levels over time to support RFID environment assessment.',
        'pdf.test_summary_noise': 'Test Summary',
        'pdf.id_col': 'ID',
        'pdf.test_name_col': 'Name',
        'pdf.duration_col': 'Duration (s)',
        'pdf.average_col': 'Average (dBm)',
        'pdf.min_col': 'Min (dBm)',
        'pdf.max_col': 'Max (dBm)',
        'pdf.max_noise_time_col': 'Max Noise Time',
        'pdf.date_time_col': 'Date/Time',
        'pdf.severity_col': 'Severity',
        'pdf.noise_chart_title': 'Noise Check',
        
        # RSSI Power Module PDF (English)
        'pdf.report_title_rssi': 'Test Report - RSSI x Power',
        'pdf.test_description_title_rssi': 'Test Description',
        'pdf.test_description_text_rssi': 'This report contains the results of RSSI x Power tests performed by FastChecker II. The tests evaluate the relationship between transmission power and received signal level (RSSI) of RFID tags, providing essential data for communication optimization and RFID system range.',
        'pdf.test_configuration_rssi': 'Test Configuration',
        'pdf.parameter': 'Parameter',
        'pdf.value': 'Value',
        'pdf.name': 'Name',
        'pdf.tag_epc': 'Tag EPC',
        'pdf.frequency': 'Frequency',
        'pdf.timestamp': 'Timestamp',
        'pdf.test_history': 'Test History',
        'pdf.name_col': 'Name',
        'pdf.tag_epc_col': 'Tag EPC',
        'pdf.freq_mhz_col': 'Freq (MHz)',
        'pdf.power_range': 'Power Range',
        'pdf.rssi_range': 'RSSI Range',
        'pdf.slope': 'Slope',
        'pdf.date_time_col': 'Date/Time',
        'pdf.rssi_chart_title': 'RSSI x Power',
        'pdf.auto_report_footer': 'Automatic report generated by FastChecker',
        
        # Antenna Module PDF (English)
        'pdf.report_title_antenna': 'Test Report - Antenna Check',
        'pdf.test_description_title_antenna': 'Test Description',
        'pdf.test_description_text_antenna': 'This report contains the results of antenna tests performed by FastChecker II. The tests evaluate RFID antenna performance through analysis of Return Loss and VSWR at different frequencies, providing essential information for RFID communication system optimization.',
        'pdf.test_statistics': 'Test Statistics',
        'pdf.total_tests': 'Total Tests:',
        'pdf.total_data_points': 'Total Data Points:',
        'pdf.freq_range_general': 'General Frequency Range:',
        'pdf.avg_power': 'Average Power:',
        'pdf.min_power': 'Minimum Power:',
        'pdf.max_power': 'Maximum Power:',
        'pdf.test_history_antenna': 'Test History',
        'pdf.name_col_antenna': 'Name',
        'pdf.power_db': 'Power (dBm)',
        'pdf.freq_range': 'Freq Range (MHz)',
        'pdf.min_return_loss': 'Min Return Loss (dBm)',
        'pdf.vswr': 'VSWR',
        'pdf.freq_at_best': 'At Freq (MHz)',
        'pdf.charts_title_antenna': 'Test Charts',
        'pdf.antenna_chart_title': 'Antenna Check',
        'pdf.test_id': 'Test ID:',
        'pdf.freq_range_detail': 'Range:',
        'pdf.points': 'Points:',
        'pdf.rl_min': 'RL Min:',
        'pdf.rl_max': 'RL Max:',
        'pdf.rl_avg': 'RL Avg:',
        
        # Population Module PDF (English)
        'pdf.population_test_data': 'Test Data',
        'pdf.population_epc_col': 'EPC',
        'pdf.population_nickname_col': 'Nickname',
        'pdf.population_comment_col': 'Comment',
        'pdf.population_coords_col': 'Coordinates',
        'pdf.population_power_col': 'Power (dBm)',
        'pdf.population_rssi_col': 'RSSI (dBm)',
        'pdf.population_margin_col': 'Margin (dBm)',
        'pdf.population_freq_col': 'Frequency',
        'pdf.population_datetime_col': 'Date / Time',
        'pdf.population_summary_num_tested': 'Number of tested tags',
        'pdf.population_summary_num_read': 'Number of read tags',
        'pdf.population_summary_num_not_read': 'Number of unread tags',
        'pdf.population_summary_avg_margin': 'Average read margin (dBm)',
        'pdf.population_summary_min_margin': 'Minimum read margin (dBm)',
        'pdf.population_no_tag_detected': 'No tag detected',
        'pdf.population_not_read': '(NOT READ)',
        
        # Quick Threshold Module PDF
        'pdf.quick_threshold_report_title': 'Relatório de Testes - FastThreshold',
        'pdf.quick_threshold_report_info': 'Informações do Relatório',
        'pdf.quick_threshold_test_summary': 'Resumo dos Testes Selecionados',
        'pdf.quick_threshold_statistics': 'Estatísticas',
        'pdf.quick_threshold_test_config': 'Configurações do Teste',
        'pdf.quick_threshold_no_freq_configured': 'Nenhuma frequência configurada',
        'pdf.quick_threshold_charts': 'Gráficos',
        'pdf.quick_threshold_chart_title': 'Gráfico de Threshold',
        'pdf.quick_threshold_stats_chart': 'Gráfico de Análise Estatística',
        'pdf.quick_threshold_stats_data': 'Dados das Curvas Estatísticas',
        'pdf.quick_threshold_chart_error': 'Não foi possível adicionar o gráfico de {chart_type}: {error}',
        'pdf.quick_threshold_date_time': 'Data/Hora:',
        'pdf.quick_threshold_module': 'Módulo:',
        'pdf.quick_threshold_test_name': 'Nome do Teste:',
        'pdf.quick_threshold_not_specified': 'Não especificado',
        'pdf.quick_threshold_epc': 'EPC',
        'pdf.quick_threshold_freq_col': 'Freq {n} (dBm)',
        'pdf.quick_threshold_total_selected': 'Total de Testes Selecionados:',
        'pdf.quick_threshold_total_measurements': 'Total de Medições:',
        'pdf.quick_threshold_tags_tested': 'Tags Testadas:',
        'pdf.quick_threshold_tags_selected': 'Tags Selecionadas:',
        'pdf.quick_threshold_tags_no_test': 'Tags sem Teste:',
        'pdf.quick_threshold_freq_label': 'Frequência',
        'pdf.quick_threshold_freq_value': 'Valor (MHz)',
        
        'threshold.error_invalid_value': 'Invalid Value',
        'threshold.error_freq_min_greater_max': 'Minimum frequency ({min} MHz) must be less than maximum ({max} MHz).\n\nPlease enter valid values.',
        'threshold.error_max_power_above': 'Maximum power {power} dBm is above the active license limit.\n\nLicense allows up to: {max_allowed} dBm\nPlease enter a value up to {max_allowed} dBm.',
        'threshold.error_max_power_below': 'Maximum power {power} dBm is below the active license limit.\n\nLicense allows: {min_allowed} to {max_allowed} dBm\nPlease enter a value between {min_allowed} and {max_allowed} dBm.',
        'threshold.error_description_required': 'Description Required',
        'threshold.error_description_required_msg': 'It is mandatory to provide a description for the test.\n\nThe description is necessary to:\n• Identify the test in the history\n• Correctly label the graphs\n• Organize and compare results',
        'threshold.error_description_duplicate': 'Duplicate Description',
        'threshold.error_description_duplicate_msg': 'The description "{description}" has already been used previously.\n\nA test with this description already exists in the history.\nPlease choose a different description.',
        'threshold.info_no_test_to_cancel': 'Information',
        'threshold.info_no_test_to_cancel_msg': 'No test is running to cancel.',
        'threshold.info_test_cancelled': 'Test Cancelled',
        
        # Population Module
        'population.select_an_action': 'Select an action',
        'population.browser_mode': 'browser mode',
        'population.tags_registered': 'tags registered',
        'population.tags_selected': 'tags selected',
        'population.register_new_tags': '+ Register New Tags',
        'population.import_tag_json': '+ Import Tag from file JSON',
        'population.select_all_tags': '+ Select All Tags',
        'population.deselect_all_tags': '+ Deselect All Tags',
        'population.erase_selected_tags': '- Erase Selected Tags',
        'population.save_selected_tags': '> Save Selected Tags (JSON)',
        'population.registered_tags': 'Registered Tags',
        'population.tag_epc': 'Tag EPC',
        'population.test_management': 'Test Management',
        'population.save_test': 'Save Test',
        'population.import_test': 'Import Test',
        'population.clear_test': 'Clear Test',
        'population.test_config': 'Test Configuration',
        'population.frequency_mhz': 'Frequency (MHz):',
        'population.power_max_dbm': 'Max Power (dBm):',
        'population.distance_m': 'Distance (m):',
        'population.power_step_db': 'Power Step (dB):',
        'population.description': 'Description:',
        'population.start_test': 'Start Test',
        'population.stop': 'Stop',
        'population.pdf_report': '📊 PDF Report',
        'population.graph_title': 'RFID Tags Population - Real Time',
        'population.graph_xlabel': 'Power (dBm)',
        'population.graph_ylabel': 'Number of Selected Tags Detected',
        'population.progress_label': 'Power Progress',
        'population.tags_detected': 'Tags Detected',
        'population.tag': 'Tag',
        'population.position': 'Position',
        'population.power': 'Power',
        'population.count': 'Count',
        'population.status': 'Status',
        'population.date_time': 'Date/Time',
        'population.graph_column': 'Graph',
        'population.table_column_epc': 'EPC',
        'population.table_column_nickname': 'Nickname',
        'population.table_column_comment': 'Comment',
        'population.table_column_coordinates': 'Coordinates',
        'population.table_column_power': 'Power (dBm)',
        'population.table_column_rssi': 'RSSI (dBm)',
        'population.table_column_margin': 'Margin (dBm)',
        'population.table_column_frequency': 'Frequency',
        'population.table_column_datetime': 'Date / Time',
        'population.test_name_column': 'Test Name',
        'population.test_name_placeholder': 'Population Test',
        'population.no_results': 'No Results',
        'population.no_results_msg': 'The selected test has no results to show.',
        'population.matplotlib_unavailable': 'Matplotlib not available',
        'population.graph_3d_title': '3D Tag Positioning',
        'population.graph_3d_error': 'Matplotlib not available\nfor 3D graph',
        'population.graph_3d_config_error': 'Error configuring\n3D Graph:',
        'population.test_data_title': 'Test Data',
        'population.edit_tag': 'Edit Tag',
        'population.nickname_label': 'Nickname:',
        'population.coordinates_label': 'Coordinates (X,Y,Z):',
        'population.power_tooltip': 'Power: {power} dBm',
        'population.epc_tooltip': 'EPC: {epc}',
        'population.epcs_tooltip': 'EPCs ({count} tags):',
        'population.report_title': 'Population Report',
        'population.system_info': 'System Information',
        'population.test_config_title': 'Test Configuration',
        'population.test_results_summary': 'Results Summary',
        'population.parameter': 'Parameter',
        'population.value': 'Value',
        'population.save_test_data': 'Save Test Data',
        'population.save_complete_report': 'Save Complete Report',
        'population.import_complete_report': 'Import Complete Report',
        'population.select_json_file': 'Select JSON File for Import',
        'population.save_selected_tags': 'Save Selected Tags',
        'population.save_pdf_report': 'Save PDF Report',
        'population.risk_image': 'Risk Image',
        'population.error_counting_tags': 'Error counting tags',
        'population.error_counting_selection': 'Error counting selection',
        'population.software_label': 'Software:',
        'population.hardware_label': 'Hardware:',
        'population.firmware_label': 'Firmware:',
        'population.serial_number_label': 'Serial Number:',
        'population.license_label': 'License:',
        'population.generated_at_label': 'Generated at:',
        'population.error_description_required': 'Description Required',
        'population.error_description_required_msg': 'It is mandatory to provide a description for the test.\n\nThe description is necessary to:\n• Identify the test in the history\n• Correctly label the graphs\n• Organize and compare results',
        'population.error_freq_blocked': 'Frequency blocked by license',
        'population.error_validation': 'Validation Error',
        'population.error_power_invalid': 'Power must be a valid number.',
        'population.warning_test_in_progress': 'Test in Progress',
        'population.warning_test_in_progress_msg': 'A test is already running.',
        'population.error_safety_stop': 'Safety Stop',
        'population.error_reflected_power_high': 'High Reflected Power',
        'population.error_power_range': 'Power must be between {min_power} and {max_power} dBm.\n\nValue entered: {value} dBm',
        'population.error_invalid_parameters': 'Invalid parameters. Check the entered values.',
        'population.warning_browser_mode': 'Browser Mode',
        'population.warning_browser_mode_msg': 'Test function unavailable without active license.',
        'population.warning_no_tags_selected': 'Warning',
        'population.warning_no_tags_selected_msg': 'No tags selected for the test.',
        'population.error_nickname_max_length': 'The nickname must have at most 4 characters.',
        'population.error_nickname_invalid_chars': 'The nickname contains invalid characters. Use only letters, numbers, spaces and common special characters (# & % @ - _ . , ! ? ( )).',
        'population.error_coordinates_format': 'Coordinates must be in the format X,Y,Z (example: 1,2,3)',
        'population.error_coordinates_numeric': 'Coordinates must contain only numbers (example: 1,2,3)',
        'population.warning_duplicate_nickname': 'Duplicate Nickname',
        'population.warning_duplicate_nickname_msg': 'The nickname \'{nickname}\' is already registered for another tag.\n\nPlease choose a different nickname.',
        'population.warning_duplicate_coordinates': 'Duplicate Coordinates',
        'population.warning_duplicate_coordinates_msg': 'The coordinates \'{coordinates}\' are already registered for another tag.\n\nPlease choose different coordinates.',
        'population.success_tag_saved': 'Tag information {epc}... saved successfully!',
        'population.error_saving_tag': 'Error saving information: {error}',
        'population.warning_no_data_export': 'No Data',
        'population.warning_no_data_export_msg': 'No test data available to export.',
        'population.success_exported': 'Data exported successfully to:\n{filename}',
        'population.error_export_failed': 'Failed to export data:\n{error}',
        'population.error_report_generation_failed': 'Failed to generate report:\n{error}',
        'population.error_save_file_failed': 'Failed to save file:\n{error}',
        'population.success_report_saved': 'PDF report generated successfully!\n\nFile: {filepath}',
        'population.error_save_test_failed': 'Failed to save test:\n{error}',
        'population.success_test_imported': 'Report \'{test_name}\' imported successfully!',
        'population.error_import_failed': 'Failed to import report:\n{error}',
        'population.success_test_cleared': 'Test cleared successfully!\n\nAll data has been removed.',
        'population.error_clear_failed': 'Failed to clear test:\n{error}',
        'population.error_hardware_not_detected': 'Hardware not detected.',
        'population.error_register_tags_failed': 'Failed to register tags: {error}',
        'population.error_invalid_json': 'Invalid JSON file format. Expected list of tags or object with \'tags\' property.',
        'population.error_reading_file': 'Read Error',
        'population.error_reading_file_msg': 'Could not read the file:\n{error}',
        'population.warning_no_data_report': 'No test data available to generate report.',
        'population.error_generate_pdf_failed': 'Error generating PDF report:\n{error}',
        'population.warning_risk_image_not_found': 'Warning',
        'population.warning_risk_image_not_found_msg': 'Risk image not found.',
        'population.error_display_risk_image': 'Error displaying Risk image:\n{error}',
        'population.success': 'Success',
        'population.error': 'Error',
        'population.error_safety_stop_temp': 'Temperature ({temp}°C) exceeded the limit of {limit}°C.\n\nThe test cannot be started for hardware safety.',
        'population.error_reflected_power_msg': 'Reflected Power ({power} dBm) exceeded the limit of {limit} dBm.\n\nCheck the radiating system (antenna).\nThe test cannot be started for hardware safety.',
        'population.error_reflected_power_during_test': 'Reflected Power ({power} dBm) exceeded the limit of {limit} dBm.\n\nCheck the radiating system (antenna).\nThe test was interrupted for hardware safety.',
        'population.success_test_saved': 'Test saved successfully!\n\nFile: {filename}\n\nData included:\n• {points} test points\n• {tags} selected tags\n• Hardware settings\n• Graph state\n• Test parameters',
        'population.confirm_clear': 'Confirm Clear',
        'population.confirm_clear_msg': 'Are you sure you want to clear all data from the current test?\n\nThis will remove:\n• All test points\n• Table data\n• Current graph\n• Detected tags\n\n⚠️ Tags selected in the \'Registered Tags\' list will be kept',
        
        # Simulator Module
        'simulator.test_config': 'Test Configuration',
        'simulator.irradiated_power': 'Irradiated Power (dBm):',
        'simulator.sensitivity': 'Sensitivity (dBm):',
        'simulator.margin': 'Margin (dB):',
        'simulator.reports': 'Reports',
        'simulator.save': '💾 Save',
        'simulator.import': '📁 Import',
        'simulator.slot': 'Slot',
        'simulator.import_data': 'Import',
        'simulator.clear': 'Clear',
        'simulator.risk': 'RISK',
        'simulator.browser_mode': 'browser mode',
        'simulator.missing_params_title': 'Missing Parameters',
        'simulator.missing_params_msg1': 'Could not find parameters in the file.',
        'simulator.missing_params_msg2': 'Please enter the values used in the test:',
        'simulator.distance': 'Distance (m):',
        'simulator.attenuator': 'Attenuator (dB):',
        'simulator.ok': 'OK',
        'simulator.cancel': 'Cancel',
        'simulator.select_test_title': 'Select a Test from Project',
        'simulator.select_test_msg': 'The project file contains multiple tests. Please select one to load:',
        'simulator.id': 'ID',
        'simulator.description': 'Description',
        'simulator.tag_epc': 'Tag EPC',
        'simulator.date': 'Date',
        'simulator.load_selected': 'Load Selected Test',
        'simulator.import_test_for_slot': 'Import Test to Slot',
        'simulator.select_project': 'Select Project',
        'simulator.project': 'Project:',
        'simulator.test_history': 'Test History',
        'simulator.epc': 'EPC',
        'simulator.date_time': 'Date/Time',
        'simulator.type': 'Type',
        'simulator.test_info': 'Test Information',
        'simulator.import_button': 'Import',
        'simulator.risk_image_enlarged': 'Risk Image Enlarged',
        'simulator.close': 'Close',
        'simulator.image_not_found': 'File \'Risco.png\' not found.\nSearched in:',
        'simulator.image_load_error': 'Error loading image:',
        'simulator.validation_error': 'Validation Error',
        'simulator.validation_error_msg': 'Please enter valid numeric values.',
        'simulator.invalid_test': 'Invalid Test',
        'simulator.invalid_test_msg': 'The selected test (\'{desc}\') does not contain measurement data (\'results\') and cannot be simulated.\n\nPlease choose another test from the list.',
        'simulator.test_info_desc': 'Description:',
        'simulator.test_info_epc': 'EPC:',
        'simulator.test_info_date': 'Date:',
        'simulator.test_info_attenuator': 'Attenuator:',
        'simulator.test_info_distance': 'Distance:',
        'simulator.test_info_duration': 'Duration:',
        'simulator.invalid_value': 'Invalid Value',
        'simulator.invalid_value_msg': 'The margin must be a positive number or zero.\n\nNegative values are not allowed.',
        'simulator.save_error': 'Save Error',
        'simulator.save_error_msg': 'Error saving report:\n{error}',
        'simulator.invalid_format': 'Invalid Format',
        'simulator.invalid_format_msg': 'The selected file is not a valid simulation report.',
        'simulator.import_report_title': 'Import Simulation Report',
        'simulator.save_report_title': 'Save Simulation Report',
        'simulator.graph_performance': 'Performance',
        'simulator.graph_frequency': 'Frequency (MHz)',
        'simulator.graph_distance': 'Distance (m)',
        'simulator.graph_forward_link': 'Forward Link (Threshold)',
        'simulator.graph_reverse_link': 'Reverse Link (Threshold)',
        'simulator.graph_link_final': 'Final Link (Threshold)',
        'simulator.graph_link_final_margin': 'Final Link (Margin {margin} dB)',
        'simulator.graph_import_file': 'Import a .json file',
        'simulator.error_irradiated_power_limit': 'Error - Irradiated Power Limit',
        'simulator.error_irradiated_power_limit_anatel': 'The maximum allowed irradiated power for Anatel licenses or frequency ranges from 800 to 1000 MHz is {max_power} dBm.\n\nEntered value: {value} dBm\nMaximum limit: {max_power} dBm\n\nPlease adjust the value to {max_power} dBm or less.',
        'simulator.error_irradiated_power_limit_etsi': 'The maximum allowed irradiated power for ETSI licenses is {max_power} dBm.\n\nEntered value: {value} dBm\nMaximum limit: {max_power} dBm\n\nPlease adjust the value to {max_power} dBm or less.',
        
        # Noise Check Module - Error Messages
        'noise.test_name_required': 'Test Name Required',
        'noise.test_name_required_msg': 'Please enter a name for the test before starting.\n\nThe test name is required and must be unique in the history.',
        'noise.test_name_duplicate': 'Duplicate Name',
        'noise.test_name_duplicate_msg': 'A test with the name \'{name}\' already exists in the history.\n\nPlease choose a different name for this test.',
        'noise.mode_required': 'Operation Mode Required',
        'noise.mode_required_msg': 'Please select an operation mode:\n\n• Single: Test with defined duration\n• Continuous: Continuous test until manually stopped',
        'noise.duration_required': 'Duration Required',
        'noise.duration_required_msg': 'In Single mode, the duration is required.\n\nPlease enter the test duration.\nExample: 60 (for 60 seconds)',
        'noise.duration_invalid': 'Invalid Duration',
        'noise.duration_invalid_msg': 'The duration \'{duration}\' is not valid.\n\nPlease enter a number greater than zero.\nExample: 60 (for 60 seconds)',
        'noise.success': 'Success',
        'noise.success_report_generated': 'PDF report of selected tests generated successfully!\n\nFile: {filepath}\n\nTests included: {count}',
        'noise.demo_mode': 'Demo Mode',
        'noise.demo_mode_msg': 'This module is running in demo mode.\n\nFor full functionality, add a valid license in the License module.',
        'noise.invalid_license': 'Invalid License',
        'noise.invalid_license_msg': 'Functionality disabled.',
        'noise.invalid_license_not_found': 'No active license found.\n\nTo use this module, activate a valid license in the License module.',
        'noise.freq_outside_license': 'Frequency outside license range',
        'noise.freq_outside_license_msg': 'Noise Check operating frequency ({freq} MHz) is outside the license allowed range.\n\nAllowed range: {min_freq} - {max_freq} MHz\nModule frequency: {freq} MHz\n\nThis module cannot operate with the current license.',
        'noise.safety_stop_temp': 'Safety Stop',
        'noise.safety_stop_temp_msg': 'Temperature ({temp}°C) exceeded the limit of {limit}°C.',
        'noise.reflected_power_high': 'High Reflected Power',
        'noise.reflected_power_high_msg': 'Reflected Power ({power:.1f} dBm) exceeded the limit of {limit} dBm.\n\nCheck the radiating system (antenna).\nThe test cannot be started for hardware safety.',
        'noise.no_test_selected_save': 'No Test Selected',
        'noise.no_test_selected_save_msg': 'Please select one or more tests in the history to save.',
        'noise.save_tests_title': 'Save Selected Tests',
        'noise.tests_saved_success': '{count} test(s) saved successfully to:\n{filename}',
        'noise.error_saving_tests': 'Error Saving',
        'noise.error_saving_tests_msg': 'Could not save tests.\nError: {error}',
        'noise.import_tests_title': 'Import Tests to History',
        'noise.no_tests_in_file': 'No Test Found',
        'noise.no_tests_in_file_msg': 'The selected file does not contain test data in the expected format.',
        'noise.import_error': 'Import Error',
        'noise.import_error_msg': 'Could not read the file.\nError: {error}',
        'noise.db_unavailable_report': 'Warning',
        'noise.db_unavailable_report_msg': 'Database not available to generate report.',
        'noise.no_test_selected_report': 'No Test Selected',
        'noise.no_test_selected_report_msg': 'Please select one or more tests in the history to generate the report.',
        'noise.no_valid_test': 'Warning',
        'noise.no_valid_test_msg': 'No valid test found among selected.',
        'noise.pdf_module_not_found': 'Error',
        'noise.pdf_module_not_found_msg': 'PDF generation module not found.\nError: {error}',
        'noise.error_generating_pdf': 'Error generating PDF report:\n{error}',
        'noise.error_unexpected_pdf': 'Unexpected error generating report:\n{error}',
        'noise.no_test_selected_delete': 'No Test Selected',
        'noise.no_test_selected_delete_msg': 'Please select one or more tests in the history to delete.',
        'noise.tests_deleted': 'Operation Completed',
        'noise.tests_deleted_msg': '{count} test(s) were deleted successfully.',
        'noise.error_loading_history': 'Error',
        'noise.error_loading_history_msg': 'Error loading history: {error}',
        'noise.name_duplicate_inline': 'Duplicate Name',
        'noise.name_duplicate_inline_msg': 'A test with the name \'{name}\' already exists in history.\n\nPlease choose a different name.',
        
        # Antenna Check Module - Error Messages
        'antenna.reset_warning': 'Reset Warning',
        'antenna.reset_warning_msg': 'Could not perform Soft Reset of the hardware.\n\nThe test will continue, but there may be problems if the hardware is in an inconsistent state.\n\nIf the problem persists, unplug and reconnect the USB cable from the reader.',
        'antenna.safety_stop': 'Safety Stop',
        'antenna.safety_stop_temp_msg': 'Temperature ({temp}°C) exceeded the limit of {limit}°C.\n\nThe test cannot be started for hardware safety.',
        'antenna.reflected_power_high': 'High Reflected Power',
        'antenna.reflected_power_high_msg': 'Reflected Power ({power} dBm) exceeded the limit of {limit} dBm.\n\nCheck the radiating system (antenna).\nThe test cannot be started for hardware safety.',
        'antenna.invalid_license': 'Invalid License',
        'antenna.test_disabled': 'The test functionality is disabled.',
        'antenna.name_empty': 'Empty Name',
        'antenna.name_empty_msg': 'The \'Name\' field cannot be empty.',
        'antenna.name_duplicate': 'Duplicate Name',
        'antenna.name_duplicate_msg': 'A test with the name \'{name}\' already exists in the history.\n\nPlease choose a different name for this test.',
        'antenna.freq_outside_ranges': 'Frequency Outside License Ranges',
        'antenna.freq_outside_ranges_msg': 'The selected frequency ({freq_min}-{freq_max} MHz) is outside the ranges allowed by the license.\n\nAllowed ranges: {ranges}\nSelected frequency: {freq_min} - {freq_max} MHz\n\nAdjust the frequency to be within one of the allowed ranges.',
        'antenna.freq_outside_range': 'Frequency Outside License Range',
        'antenna.freq_outside_range_msg': 'The selected frequency ({freq_min}-{freq_max} MHz) is outside the range allowed by the license.\n\nAllowed range: {min_freq} - {max_freq} MHz\nSelected frequency: {freq_min} - {freq_max} MHz\n\nAdjust the frequency to be within the allowed range.',
        'antenna.power_outside_range': 'Power Outside License Range',
        'antenna.power_outside_range_msg': 'The selected power ({power} dBm) is outside the range allowed by the license.\n\nAllowed range: {min_power} - {max_power} dBm\nSelected power: {power} dBm\n\nAdjust the power to be within the allowed range.',
        'antenna.validation_error': 'Validation Error',
        'antenna.invalid_freq_values': 'Invalid frequency values.',
        'antenna.invalid_power_value': 'Invalid power value.',
        'antenna.communication_error': 'Communication Error',
        'antenna.communication_error_msg': 'Failed to open COM{port}. Check the hardware connection.',
        'antenna.protection_activated': 'Protection Activated',
        'antenna.protection_activated_msg': 'Test interrupted. Return Loss too high: {power} dBm.',
        'antenna.scan_error': 'Scan Error',
        'antenna.scan_error_msg': 'An error occurred during scanning: {error}',
        'antenna.no_tests': 'No Tests',
        'antenna.no_tests_msg': 'File does not contain valid test data.',
        'antenna.success': 'Success',
        'antenna.tests_imported': '{count} test(s) imported.',
        'antenna.tests_saved': '{count} test(s) saved to:\n{filename}',
        'antenna.error': 'Error',
        'antenna.import_failed': 'Failed to import.\n{error}',
        'antenna.save_failed': 'Failed to save tests.\n{error}',
        'antenna.database_unavailable': 'Database not available.',
        'antenna.nothing_selected': 'Nothing Selected',
        'antenna.select_to_save': 'Select tests in the history to save.',
        'antenna.select_to_delete': 'Select tests in the history to delete.',
        'antenna.empty_file': 'Empty File',
        'antenna.no_tests_in_file': 'No tests found in the file.',
        'antenna.invalid_file_structure': 'Invalid file: \'tests\' structure not found.',
        'antenna.invalid_json': 'Invalid JSON file.',
        'antenna.import_failed_error': 'Failed to import tests.\n{error}',
        'antenna.confirm_import': 'Confirm Import',
        'antenna.confirm_import_msg': 'Import {count} antenna test(s)?\n\nFile: {filename}',
        'antenna.tests_imported_success': '{count} test(s) imported successfully.',
        'antenna.tests_deleted': '{count} test(s) deleted.',
        'antenna.save_tests_dialog': 'Save Antenna Tests',
        'antenna.import_tests_dialog': 'Import Antenna Tests',
        'antenna.import_tests_title': 'Import Antenna Tests',
        
        # RSSI x Power Module - Validation Messages
        'rssi_power.test_name_required': 'Test Name Required',
        'rssi_power.test_name_required_msg': 'Please enter a name for the test before starting.\n\nThe test name is required.',
        'rssi_power.freq_outside_license': 'Frequency Outside License Bands',
        'rssi_power.freq_outside_msg': 'The selected frequency ({freq} MHz) is outside the frequency bands permitted by the license.\n\nAllowed bands: {allowed}\nExcluded bands: {excluded}\nSelected frequency: {freq} MHz\n\nAdjust the frequency to be within one of the permitted bands.',
        'rssi_power.freq_outside_scan_msg': 'The selected frequency ({freq} MHz) is outside the frequency bands permitted by the license.\n\nAllowed bands: {allowed}\nExcluded bands: {excluded}\nSelected frequency: {freq} MHz\n\nAdjust the frequency to be within one of the permitted bands before scanning.',
        'rssi_power.test_running_scan_msg': 'Stop the current test before searching for new tags.',
        'rssi_power.invalid_license': 'Invalid License',
        'rssi_power.invalid_license_msg': 'No active license found.\n\nTo use this module, activate a valid license in the License module.',
        'rssi_power.demo_mode': 'Demo Mode',
        'rssi_power.demo_mode_msg': 'This module is running in demo mode.',
        'rssi_power.dll_error': 'DLL Error',
        'rssi_power.dll_error_msg': 'File \'{dll}\' not found.',
        'rssi_power.no_tag': 'No Tag',
        'rssi_power.no_tag_msg': 'Please select a tag to test.',
        'rssi_power.name_duplicate': 'Duplicate Name',
        'rssi_power.name_duplicate_msg': 'A test with the name \'{name}\' already exists in the history.\n\nPlease choose a different name for this test.',
        'rssi_power.test_running': 'Test in Progress',
        'rssi_power.test_running_msg': 'There is already a test in execution.',
        'rssi_power.browser_warning': 'Browser Mode',
        'rssi_power.browser_warning_msg': 'Test function unavailable without an active license.',
        'rssi_power.safety_stop': 'Safety Stop',
        'rssi_power.safety_stop_msg': 'Temperature ({temp}°C) exceeded the limit of {limit}°C.\n\nThe test cannot be started for hardware safety.',
        'rssi_power.hardware_error': 'Hardware Error',
        'rssi_power.hardware_error_msg': 'Could not connect to COM{port}',
        'rssi_power.tag_search': 'Tag Search',
        'rssi_power.no_tags_found': 'No tags found in the environment.',
        'rssi_power.select_tag_first': 'Select a Tag First',
        'rssi_power.select_tag_first_msg': 'Please select a tag from the list before running the test.',
        
        # App Shell - Language Selector
        'app.language': 'Language',
        'app.language_portuguese': 'Português',
        'app.language_english': 'English',
        'app.warning': 'Warning',
        'app.validation_error': 'Validation Error',
        'app.clear': 'Clear',
        'app.no_data': 'No Data',
        'app.success': 'Success',
        'app.save_error': 'Save Error',
        'app.read_error': 'Read Error',
        'app.invalid_file': 'Invalid File',
        'app.confirm_import': 'Confirm Import',
        'app.import_error': 'Import Error',
        'app.error': 'Error',
        'app.migrate_data': 'Migrate Data',
        'app.invalid_threshold': 'Invalid Threshold',
        'app.status': 'Status',
    }
}

# Idioma padrão
DEFAULT_LANGUAGE = 'pt'

# Arquivo de persistência de preferência de idioma
LANGUAGE_PREF_FILE = os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(__file__))), 'data', 'language_preference.json')

class Translator:
    """Classe responsável pelo gerenciamento de traduções"""
    
    def __init__(self, language=None):
        self._language = language or self._load_language_preference()
        self._listeners = []  # Lista de callbacks para notificar mudanças de idioma
    
    def _load_language_preference(self):
        """Carrega a preferência de idioma salva, ou usa o padrão"""
        try:
            if os.path.exists(LANGUAGE_PREF_FILE):
                with open(LANGUAGE_PREF_FILE, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    lang = data.get('language', DEFAULT_LANGUAGE)
                    if lang in TRANSLATIONS:
                        return lang
        except Exception as e:
            print(f"⚠️ Erro ao carregar preferência de idioma: {e}")
        return DEFAULT_LANGUAGE
    
    def _save_language_preference(self, language):
        """Salva a preferência de idioma"""
        try:
            os.makedirs(os.path.dirname(LANGUAGE_PREF_FILE), exist_ok=True)
            with open(LANGUAGE_PREF_FILE, 'w', encoding='utf-8') as f:
                json.dump({'language': language}, f, ensure_ascii=False, indent=2)
        except Exception as e:
            print(f"⚠️ Erro ao salvar preferência de idioma: {e}")
    
    def set_language(self, language):
        """Define o idioma atual e notifica os listeners"""
        if language in TRANSLATIONS:
            old_language = self._language
            self._language = language
            self._save_language_preference(language)
            print(f"🌐 Translator: Idioma alterado para {language}, notificando {len(self._listeners)} listener(s)")
            # Notifica todos os listeners sobre a mudança
            for i, callback in enumerate(self._listeners):
                try:
                    print(f"📢 Notificando listener {i+1}/{len(self._listeners)}: {callback}")
                    callback(old_language, language)
                except Exception as e:
                    print(f"⚠️ Erro ao notificar listener {i+1} de idioma: {e}")
                    import traceback
                    traceback.print_exc()
        else:
            print(f"⚠️ Idioma inválido: {language}")
    
    def get_language(self):
        """Retorna o idioma atual"""
        return self._language
    
    def translate(self, key, default=None):
        """Traduz uma chave para o idioma atual"""
        if default is None:
            default = key  # Se não fornecer default, usa a própria chave
        return TRANSLATIONS.get(self._language, TRANSLATIONS[DEFAULT_LANGUAGE]).get(key, default)
    
    def t(self, key, default=None):
        """Alias para translate (mais curto)"""
        return self.translate(key, default)
    
    def add_language_change_listener(self, callback):
        """Adiciona um callback que será chamado quando o idioma mudar"""
        if callback not in self._listeners:
            self._listeners.append(callback)
    
    def remove_language_change_listener(self, callback):
        """Remove um callback da lista de listeners"""
        if callback in self._listeners:
            self._listeners.remove(callback)

# Instância global do tradutor
_translator_instance = None

def get_translator():
    """Retorna a instância global do tradutor (singleton)"""
    global _translator_instance
    if _translator_instance is None:
        _translator_instance = Translator()
    return _translator_instance

def t(key, default=None):
    """Função de conveniência para tradução rápida"""
    return get_translator().translate(key, default)

